/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.IOPlanner;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.RangeOptimiser;
import software.amazon.s3.analyticsaccelerator.io.physical.prefetcher.SequentialPatternDetector;
import software.amazon.s3.analyticsaccelerator.io.physical.prefetcher.SequentialReadProgression;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class BlockManager
implements Closeable {
    private final S3URI s3URI;
    private final MetadataStore metadataStore;
    private final BlockStore blockStore;
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final SequentialPatternDetector patternDetector;
    private final SequentialReadProgression sequentialReadProgression;
    private final IOPlanner ioPlanner;
    private final PhysicalIOConfiguration configuration;
    private final RangeOptimiser rangeOptimiser;
    private static final String OPERATION_MAKE_RANGE_AVAILABLE = "block.manager.make.range.available";

    public BlockManager(@NonNull S3URI s3URI, @NonNull ObjectClient objectClient, @NonNull MetadataStore metadataStore, @NonNull Telemetry telemetry, @NonNull PhysicalIOConfiguration configuration) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.objectClient = objectClient;
        this.metadataStore = metadataStore;
        this.telemetry = telemetry;
        this.configuration = configuration;
        this.blockStore = new BlockStore(s3URI, metadataStore);
        this.patternDetector = new SequentialPatternDetector(this.blockStore);
        this.sequentialReadProgression = new SequentialReadProgression(configuration);
        this.ioPlanner = new IOPlanner(this.blockStore);
        this.rangeOptimiser = new RangeOptimiser(configuration);
    }

    public synchronized Optional<Block> getBlock(long pos) {
        return this.blockStore.getBlock(pos);
    }

    public synchronized void makePositionAvailable(long pos, ReadMode readMode) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        if (this.getBlock(pos).isPresent()) {
            return;
        }
        this.makeRangeAvailable(pos, 1L, readMode);
    }

    private boolean isRangeAvailable(long pos, long len) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0L <= len, "`len` must not be negative");
        long lastByteOfRange = pos + len - 1L;
        OptionalLong nextMissingByte = this.blockStore.findNextMissingByte(pos);
        if (nextMissingByte.isPresent()) {
            return lastByteOfRange < nextMissingByte.getAsLong();
        }
        return true;
    }

    public synchronized void makeRangeAvailable(long pos, long len, ReadMode readMode) {
        long generation;
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0L <= len, "`len` must not be negative");
        if (this.isRangeAvailable(pos, len)) {
            return;
        }
        long effectiveEnd = pos + Math.max(len, this.configuration.getReadAheadBytes()) - 1L;
        if (this.patternDetector.isSequentialRead(pos)) {
            generation = this.patternDetector.getGeneration(pos);
            effectiveEnd = Math.max(effectiveEnd, this.truncatePos(pos + this.sequentialReadProgression.getSizeForGeneration(generation)));
        } else {
            generation = 0L;
        }
        long effectiveEndFinal = effectiveEnd;
        this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_MAKE_RANGE_AVAILABLE)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(pos, pos + len - 1L))).attribute(StreamAttributes.effectiveRange(pos, effectiveEndFinal))).attribute(StreamAttributes.generation(generation))).build(), () -> {
            List<Range> missingRanges = this.ioPlanner.planRead(pos, effectiveEndFinal, this.getLastObjectByte());
            List<Range> splits = this.rangeOptimiser.splitRanges(missingRanges);
            splits.forEach(r -> {
                Block block = new Block(this.s3URI, this.objectClient, this.telemetry, r.getStart(), r.getEnd(), generation, readMode);
                this.blockStore.add(block);
            });
        });
    }

    private long getLastObjectByte() {
        return this.metadataStore.get(this.s3URI).getContentLength() - 1L;
    }

    private long truncatePos(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return Math.min(pos, this.getLastObjectByte());
    }

    @Override
    public void close() {
        this.blockStore.close();
    }
}

