/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Blob;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockManager;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Inner class is created very infrequently, and fluency justifies the extra pointer")
public class BlobStore
implements Closeable {
    private final Map<S3URI, Blob> blobMap;
    private final MetadataStore metadataStore;
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final PhysicalIOConfiguration configuration;

    public BlobStore(@NonNull MetadataStore metadataStore, @NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, final @NonNull PhysicalIOConfiguration configuration) {
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.metadataStore = metadataStore;
        this.objectClient = objectClient;
        this.telemetry = telemetry;
        this.blobMap = Collections.synchronizedMap(new LinkedHashMap<S3URI, Blob>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<S3URI, Blob> eldest) {
                return this.size() > configuration.getBlobStoreCapacity();
            }
        });
        this.configuration = configuration;
    }

    public Blob get(S3URI s3URI) {
        return this.blobMap.computeIfAbsent(s3URI, uri -> new Blob((S3URI)uri, this.metadataStore, new BlockManager((S3URI)uri, this.objectClient, this.metadataStore, this.telemetry, this.configuration), this.telemetry));
    }

    @Override
    public void close() {
        this.blobMap.forEach((k, v) -> v.close());
    }
}

