/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.FooterPrefetchSize;
import software.amazon.s3.analyticsaccelerator.request.Range;

public final class ParquetUtils {
    private ParquetUtils() {
    }

    public static Optional<Range> getFileTailRange(LogicalIOConfiguration logicalIOConfiguration, long startRange, long contentLength) {
        FooterPrefetchSize footerPrefetchSize = ParquetUtils.getFooterPrefetchSize(logicalIOConfiguration, contentLength);
        if (contentLength > footerPrefetchSize.getSize()) {
            startRange = contentLength - footerPrefetchSize.getFileMetadataPrefetchSize();
        }
        if (startRange < contentLength) {
            return Optional.of(new Range(startRange, contentLength - 1L));
        }
        return Optional.empty();
    }

    public static List<Range> getFileTailPrefetchRanges(LogicalIOConfiguration logicalIOConfiguration, long startRange, long contentLength) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        FooterPrefetchSize footerPrefetchSize = ParquetUtils.getFooterPrefetchSize(logicalIOConfiguration, contentLength);
        if (contentLength > footerPrefetchSize.getSize()) {
            boolean shouldPrefetchSmallFile;
            boolean bl = shouldPrefetchSmallFile = logicalIOConfiguration.isSmallObjectsPrefetchingEnabled() && contentLength <= logicalIOConfiguration.getSmallObjectSizeThreshold();
            if (!shouldPrefetchSmallFile) {
                long fileMetadataStartIndex = contentLength - footerPrefetchSize.getFileMetadataPrefetchSize();
                ranges.add(new Range(fileMetadataStartIndex, contentLength - 1L));
                if (logicalIOConfiguration.isPrefetchPageIndexEnabled()) {
                    ranges.add(new Range(fileMetadataStartIndex - footerPrefetchSize.getPageIndexPrefetchSize(), fileMetadataStartIndex - 1L));
                }
                return ranges;
            }
        }
        if (startRange < contentLength) {
            ranges.add(new Range(startRange, contentLength - 1L));
        }
        return ranges;
    }

    private static FooterPrefetchSize getFooterPrefetchSize(LogicalIOConfiguration logicalIOConfiguration, long contentLength) {
        if (contentLength > logicalIOConfiguration.getLargeFileSize()) {
            return new FooterPrefetchSize(logicalIOConfiguration.getPrefetchLargeFileMetadataSize(), logicalIOConfiguration.getPrefetchLargeFilePageIndexSize());
        }
        return new FooterPrefetchSize(logicalIOConfiguration.getPrefetchFileMetadataSize(), logicalIOConfiguration.getPrefetchFilePageIndexSize());
    }

    public static List<Integer> constructRowGroupsToPrefetch() {
        ArrayList<Integer> rowGroupsToPrefetch = new ArrayList<Integer>();
        rowGroupsToPrefetch.add(0);
        return rowGroupsToPrefetch;
    }

    public static List<Integer> constructRowGroupsToPrefetch(ColumnMetadata columnMetadata) {
        ArrayList<Integer> rowGroupsToPrefetch = new ArrayList<Integer>();
        rowGroupsToPrefetch.add(columnMetadata.getRowGroupIndex());
        return rowGroupsToPrefetch;
    }
}

