/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.parquet.org.apache.thrift.transport.sasl;

import java.nio.ByteBuffer;
import software.amazon.s3.shaded.parquet.org.apache.thrift.EncodingUtils;
import software.amazon.s3.shaded.parquet.org.apache.thrift.transport.sasl.FrameWriter;
import software.amazon.s3.shaded.parquet.org.apache.thrift.utils.StringUtils;

public class DataFrameWriter
extends FrameWriter {
    @Override
    public void withOnlyPayload(byte[] payload, int offset, int length) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Previous write is not yet complete, with " + this.frameBytes.remaining() + " bytes left.");
        }
        this.frameBytes = this.buildFrameWithPayload(payload, offset, length);
    }

    @Override
    protected ByteBuffer buildFrame(byte[] header, int headerOffset, int headerLength, byte[] payload, int payloadOffset, int payloadLength) {
        if (header != null && headerLength > 0) {
            throw new IllegalArgumentException("Extra header [" + StringUtils.bytesToHexString(header) + "] offset " + payloadOffset + " length " + payloadLength);
        }
        return this.buildFrameWithPayload(payload, payloadOffset, payloadLength);
    }

    private ByteBuffer buildFrameWithPayload(byte[] payload, int offset, int length) {
        byte[] bytes = new byte[4 + length];
        EncodingUtils.encodeBigEndian(length, bytes, 0);
        System.arraycopy(payload, offset, bytes, 4, length);
        return ByteBuffer.wrap(bytes);
    }
}

