/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.Referrer;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public final class GetRequest {
    @NonNull
    private final S3URI s3Uri;
    @NonNull
    private final Range range;
    @NonNull
    private final Referrer referrer;

    @Generated
    GetRequest(@NonNull S3URI s3Uri, @NonNull Range range, @NonNull Referrer referrer) {
        if (s3Uri == null) {
            throw new NullPointerException("s3Uri is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        if (referrer == null) {
            throw new NullPointerException("referrer is marked non-null but is null");
        }
        this.s3Uri = s3Uri;
        this.range = range;
        this.referrer = referrer;
    }

    @Generated
    public static GetRequestBuilder builder() {
        return new GetRequestBuilder();
    }

    @NonNull
    @Generated
    public S3URI getS3Uri() {
        return this.s3Uri;
    }

    @NonNull
    @Generated
    public Range getRange() {
        return this.range;
    }

    @NonNull
    @Generated
    public Referrer getReferrer() {
        return this.referrer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRequest)) {
            return false;
        }
        GetRequest other = (GetRequest)o;
        S3URI this$s3Uri = this.getS3Uri();
        S3URI other$s3Uri = other.getS3Uri();
        if (this$s3Uri == null ? other$s3Uri != null : !((Object)this$s3Uri).equals(other$s3Uri)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Referrer this$referrer = this.getReferrer();
        Referrer other$referrer = other.getReferrer();
        return !(this$referrer == null ? other$referrer != null : !((Object)this$referrer).equals(other$referrer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S3URI $s3Uri = this.getS3Uri();
        result = result * 59 + ($s3Uri == null ? 43 : ((Object)$s3Uri).hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Referrer $referrer = this.getReferrer();
        result = result * 59 + ($referrer == null ? 43 : ((Object)$referrer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetRequest(s3Uri=" + this.getS3Uri() + ", range=" + this.getRange() + ", referrer=" + this.getReferrer() + ")";
    }

    @Generated
    public static class GetRequestBuilder {
        @Generated
        private S3URI s3Uri;
        @Generated
        private Range range;
        @Generated
        private Referrer referrer;

        @Generated
        GetRequestBuilder() {
        }

        @Generated
        public GetRequestBuilder s3Uri(@NonNull S3URI s3Uri) {
            if (s3Uri == null) {
                throw new NullPointerException("s3Uri is marked non-null but is null");
            }
            this.s3Uri = s3Uri;
            return this;
        }

        @Generated
        public GetRequestBuilder range(@NonNull Range range) {
            if (range == null) {
                throw new NullPointerException("range is marked non-null but is null");
            }
            this.range = range;
            return this;
        }

        @Generated
        public GetRequestBuilder referrer(@NonNull Referrer referrer) {
            if (referrer == null) {
                throw new NullPointerException("referrer is marked non-null but is null");
            }
            this.referrer = referrer;
            return this;
        }

        @Generated
        public GetRequest build() {
            return new GetRequest(this.s3Uri, this.range, this.referrer);
        }

        @Generated
        public String toString() {
            return "GetRequest.GetRequestBuilder(s3Uri=" + this.s3Uri + ", range=" + this.range + ", referrer=" + this.referrer + ")";
        }
    }
}

