/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.impl;

import java.io.IOException;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class PhysicalIOImpl
implements PhysicalIO {
    private final S3URI s3URI;
    private final MetadataStore metadataStore;
    private final BlobStore blobStore;
    private final Telemetry telemetry;
    private final long physicalIOBirth = System.nanoTime();
    private static final String OPERATION_READ = "physical.io.read";
    private static final String OPERATION_EXECUTE = "physical.io.execute";
    private static final String FLAVOR_TAIL = "tail";
    private static final String FLAVOR_BYTE = "byte";

    public PhysicalIOImpl(@NonNull S3URI s3URI, @NonNull MetadataStore metadataStore, @NonNull BlobStore blobStore, @NonNull Telemetry telemetry) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (blobStore == null) {
            throw new NullPointerException("blobStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.metadataStore = metadataStore;
        this.blobStore = blobStore;
        this.telemetry = telemetry;
    }

    @Override
    public ObjectMetadata metadata() {
        return this.metadataStore.get(this.s3URI);
    }

    @Override
    public int read(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_BYTE))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(pos, pos))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.s3URI).read(pos));
    }

    @Override
    public int read(byte[] buf, int off, int len, long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(pos, pos + (long)len - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.s3URI).read(buf, off, len, pos));
    }

    @Override
    public int readTail(byte[] buf, int off, int len) throws IOException {
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        long contentLength = this.contentLength();
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_TAIL))).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(contentLength - (long)len, contentLength - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.s3URI).read(buf, off, len, contentLength - (long)len));
    }

    @Override
    public IOPlanExecution execute(IOPlan ioPlan) {
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_EXECUTE)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.ioPlan(ioPlan))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.s3URI).execute(ioPlan));
    }

    private long contentLength() {
        return this.metadata().getContentLength();
    }

    @Override
    public void close() throws IOException {
    }
}

