/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockManager;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanState;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class Blob
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Blob.class);
    private static final String OPERATION_EXECUTE = "blob.execute";
    private final S3URI s3URI;
    private final BlockManager blockManager;
    private final MetadataStore metadataStore;
    private final Telemetry telemetry;

    public Blob(@NonNull S3URI s3URI, @NonNull MetadataStore metadataStore, @NonNull BlockManager blockManager, @NonNull Telemetry telemetry) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (blockManager == null) {
            throw new NullPointerException("blockManager is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.metadataStore = metadataStore;
        this.blockManager = blockManager;
        this.telemetry = telemetry;
    }

    public int read(long pos) {
        Preconditions.checkArgument(pos >= 0L, "`pos` must be non-negative");
        this.blockManager.makePositionAvailable(pos, ReadMode.SYNC);
        return this.blockManager.getBlock(pos).get().read(pos);
    }

    public int read(byte[] buf, int off, int len, long pos) {
        int numBytesRead;
        int bytesRead;
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        this.blockManager.makeRangeAvailable(pos, len, ReadMode.SYNC);
        long nextPosition = pos;
        for (numBytesRead = 0; numBytesRead < len && nextPosition < this.contentLength(); numBytesRead += bytesRead, nextPosition += (long)bytesRead) {
            long nextPositionFinal = nextPosition;
            Block nextBlock = this.blockManager.getBlock(nextPosition).orElseThrow(() -> new IllegalStateException(String.format("This block (for position %s) should have been available.", nextPositionFinal)));
            bytesRead = nextBlock.read(buf, off + numBytesRead, len - numBytesRead, nextPosition);
            if (bytesRead != -1) continue;
            return numBytesRead;
        }
        return numBytesRead;
    }

    public IOPlanExecution execute(IOPlan plan) {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_EXECUTE)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.ioPlan(plan))).build(), () -> {
            try {
                plan.getPrefetchRanges().forEach(range -> this.blockManager.makeRangeAvailable(range.getStart(), range.getLength(), ReadMode.ASYNC));
                return IOPlanExecution.builder().state(IOPlanState.SUBMITTED).build();
            }
            catch (Exception e) {
                LOG.error("Failed to submit IOPlan to PhysicalIO", (Throwable)e);
                return IOPlanExecution.builder().state(IOPlanState.FAILED).build();
            }
        });
    }

    private long contentLength() {
        return this.metadataStore.get(this.s3URI).getContentLength();
    }

    @Override
    public void close() {
        this.blockManager.close();
    }
}

