/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public class PhysicalIOConfiguration {
    private static final int DEFAULT_CAPACITY_BLOB_STORE = 50;
    private static final int DEFAULT_CAPACITY_METADATA_STORE = 50;
    private static final boolean DEFAULT_USE_SINGLE_CACHE = true;
    private static final long DEFAULT_BLOCK_SIZE_BYTES = 0x800000L;
    private static final long DEFAULT_READ_AHEAD_BYTES = 65536L;
    private static final long DEFAULT_MAX_RANGE_SIZE = 0x800000L;
    private static final long DEFAULT_PART_SIZE = 0x800000L;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_BASE = 2.0;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_SPEED = 1.0;
    private int blobStoreCapacity;
    private static final String BLOB_STORE_CAPACITY_KEY = "blobstore.capacity";
    private int metadataStoreCapacity;
    private static final String METADATA_STORE_CAPACITY_KEY = "metadatastore.capacity";
    private long blockSizeBytes;
    private static final String BLOCK_SIZE_BYTES_KEY = "blocksizebytes";
    private long readAheadBytes;
    private static final String READ_AHEAD_BYTES_KEY = "readaheadbytes";
    private long maxRangeSizeBytes;
    private static final String MAX_RANGE_SIZE_BYTES_KEY = "maxrangesizebytes";
    private long partSizeBytes;
    private static final String PART_SIZE_BYTES_KEY = "partsizebytes";
    private double sequentialPrefetchBase;
    private static final String SEQUENTIAL_PREFETCH_BASE_KEY = "sequentialprefetch.base";
    private double sequentialPrefetchSpeed;
    private static final String SEQUENTIAL_PREFETCH_SPEED_KEY = "sequentialprefetch.speed";
    public static final PhysicalIOConfiguration DEFAULT = PhysicalIOConfiguration.builder().build();

    public static PhysicalIOConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return PhysicalIOConfiguration.builder().blobStoreCapacity(configuration.getInt(BLOB_STORE_CAPACITY_KEY, 50)).metadataStoreCapacity(configuration.getInt(METADATA_STORE_CAPACITY_KEY, 50)).blockSizeBytes(configuration.getLong(BLOCK_SIZE_BYTES_KEY, 0x800000L)).readAheadBytes(configuration.getLong(READ_AHEAD_BYTES_KEY, 65536L)).maxRangeSizeBytes(configuration.getLong(MAX_RANGE_SIZE_BYTES_KEY, 0x800000L)).partSizeBytes(configuration.getLong(PART_SIZE_BYTES_KEY, 0x800000L)).sequentialPrefetchBase(configuration.getDouble(SEQUENTIAL_PREFETCH_BASE_KEY, 2.0)).sequentialPrefetchSpeed(configuration.getDouble(SEQUENTIAL_PREFETCH_SPEED_KEY, 1.0)).build();
    }

    private PhysicalIOConfiguration(int blobStoreCapacity, int metadataStoreCapacity, long blockSizeBytes, long readAheadBytes, long maxRangeSizeBytes, long partSizeBytes, double sequentialPrefetchBase, double sequentialPrefetchSpeed) {
        Preconditions.checkArgument(blobStoreCapacity > 0, "`blobStoreCapacity` must be positive");
        Preconditions.checkArgument(metadataStoreCapacity > 0, "`metadataStoreCapacity` must be positive");
        Preconditions.checkArgument(blockSizeBytes > 0L, "`blockSizeBytes` must be positive");
        Preconditions.checkArgument(readAheadBytes > 0L, "`readAheadLengthBytes` must be positive");
        Preconditions.checkArgument(maxRangeSizeBytes > 0L, "`maxRangeSize` must be positive");
        Preconditions.checkArgument(partSizeBytes > 0L, "`partSize` must be positive");
        Preconditions.checkArgument(sequentialPrefetchBase > 0.0, "`sequentialPrefetchBase` must be positive");
        Preconditions.checkArgument(sequentialPrefetchSpeed > 0.0, "`sequentialPrefetchSpeed` must be positive");
        this.blobStoreCapacity = blobStoreCapacity;
        this.metadataStoreCapacity = metadataStoreCapacity;
        this.blockSizeBytes = blockSizeBytes;
        this.readAheadBytes = readAheadBytes;
        this.maxRangeSizeBytes = maxRangeSizeBytes;
        this.partSizeBytes = partSizeBytes;
        this.sequentialPrefetchBase = sequentialPrefetchBase;
        this.sequentialPrefetchSpeed = sequentialPrefetchSpeed;
    }

    @Generated
    private static int $default$blobStoreCapacity() {
        return 50;
    }

    @Generated
    private static int $default$metadataStoreCapacity() {
        return 50;
    }

    @Generated
    private static long $default$blockSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static long $default$readAheadBytes() {
        return 65536L;
    }

    @Generated
    private static long $default$maxRangeSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static long $default$partSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static double $default$sequentialPrefetchBase() {
        return 2.0;
    }

    @Generated
    private static double $default$sequentialPrefetchSpeed() {
        return 1.0;
    }

    @Generated
    public static PhysicalIOConfigurationBuilder builder() {
        return new PhysicalIOConfigurationBuilder();
    }

    @Generated
    public int getBlobStoreCapacity() {
        return this.blobStoreCapacity;
    }

    @Generated
    public int getMetadataStoreCapacity() {
        return this.metadataStoreCapacity;
    }

    @Generated
    public long getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    @Generated
    public long getReadAheadBytes() {
        return this.readAheadBytes;
    }

    @Generated
    public long getMaxRangeSizeBytes() {
        return this.maxRangeSizeBytes;
    }

    @Generated
    public long getPartSizeBytes() {
        return this.partSizeBytes;
    }

    @Generated
    public double getSequentialPrefetchBase() {
        return this.sequentialPrefetchBase;
    }

    @Generated
    public double getSequentialPrefetchSpeed() {
        return this.sequentialPrefetchSpeed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalIOConfiguration)) {
            return false;
        }
        PhysicalIOConfiguration other = (PhysicalIOConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlobStoreCapacity() != other.getBlobStoreCapacity()) {
            return false;
        }
        if (this.getMetadataStoreCapacity() != other.getMetadataStoreCapacity()) {
            return false;
        }
        if (this.getBlockSizeBytes() != other.getBlockSizeBytes()) {
            return false;
        }
        if (this.getReadAheadBytes() != other.getReadAheadBytes()) {
            return false;
        }
        if (this.getMaxRangeSizeBytes() != other.getMaxRangeSizeBytes()) {
            return false;
        }
        if (this.getPartSizeBytes() != other.getPartSizeBytes()) {
            return false;
        }
        if (Double.compare(this.getSequentialPrefetchBase(), other.getSequentialPrefetchBase()) != 0) {
            return false;
        }
        return Double.compare(this.getSequentialPrefetchSpeed(), other.getSequentialPrefetchSpeed()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalIOConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlobStoreCapacity();
        result = result * 59 + this.getMetadataStoreCapacity();
        long $blockSizeBytes = this.getBlockSizeBytes();
        result = result * 59 + (int)($blockSizeBytes >>> 32 ^ $blockSizeBytes);
        long $readAheadBytes = this.getReadAheadBytes();
        result = result * 59 + (int)($readAheadBytes >>> 32 ^ $readAheadBytes);
        long $maxRangeSizeBytes = this.getMaxRangeSizeBytes();
        result = result * 59 + (int)($maxRangeSizeBytes >>> 32 ^ $maxRangeSizeBytes);
        long $partSizeBytes = this.getPartSizeBytes();
        result = result * 59 + (int)($partSizeBytes >>> 32 ^ $partSizeBytes);
        long $sequentialPrefetchBase = Double.doubleToLongBits(this.getSequentialPrefetchBase());
        result = result * 59 + (int)($sequentialPrefetchBase >>> 32 ^ $sequentialPrefetchBase);
        long $sequentialPrefetchSpeed = Double.doubleToLongBits(this.getSequentialPrefetchSpeed());
        result = result * 59 + (int)($sequentialPrefetchSpeed >>> 32 ^ $sequentialPrefetchSpeed);
        return result;
    }

    @Generated
    public static class PhysicalIOConfigurationBuilder {
        @Generated
        private boolean blobStoreCapacity$set;
        @Generated
        private int blobStoreCapacity$value;
        @Generated
        private boolean metadataStoreCapacity$set;
        @Generated
        private int metadataStoreCapacity$value;
        @Generated
        private boolean blockSizeBytes$set;
        @Generated
        private long blockSizeBytes$value;
        @Generated
        private boolean readAheadBytes$set;
        @Generated
        private long readAheadBytes$value;
        @Generated
        private boolean maxRangeSizeBytes$set;
        @Generated
        private long maxRangeSizeBytes$value;
        @Generated
        private boolean partSizeBytes$set;
        @Generated
        private long partSizeBytes$value;
        @Generated
        private boolean sequentialPrefetchBase$set;
        @Generated
        private double sequentialPrefetchBase$value;
        @Generated
        private boolean sequentialPrefetchSpeed$set;
        @Generated
        private double sequentialPrefetchSpeed$value;
        @Generated
        private int blobStoreCapacity;
        @Generated
        private int metadataStoreCapacity;
        @Generated
        private long blockSizeBytes;
        @Generated
        private long readAheadBytes;
        @Generated
        private long maxRangeSizeBytes;
        @Generated
        private long partSizeBytes;
        @Generated
        private double sequentialPrefetchBase;
        @Generated
        private double sequentialPrefetchSpeed;

        @Generated
        PhysicalIOConfigurationBuilder() {
        }

        @Generated
        public PhysicalIOConfigurationBuilder blobStoreCapacity(int blobStoreCapacity) {
            this.blobStoreCapacity$value = blobStoreCapacity;
            this.blobStoreCapacity$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder metadataStoreCapacity(int metadataStoreCapacity) {
            this.metadataStoreCapacity$value = metadataStoreCapacity;
            this.metadataStoreCapacity$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockSizeBytes(long blockSizeBytes) {
            this.blockSizeBytes$value = blockSizeBytes;
            this.blockSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder readAheadBytes(long readAheadBytes) {
            this.readAheadBytes$value = readAheadBytes;
            this.readAheadBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder maxRangeSizeBytes(long maxRangeSizeBytes) {
            this.maxRangeSizeBytes$value = maxRangeSizeBytes;
            this.maxRangeSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder partSizeBytes(long partSizeBytes) {
            this.partSizeBytes$value = partSizeBytes;
            this.partSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchBase(double sequentialPrefetchBase) {
            this.sequentialPrefetchBase$value = sequentialPrefetchBase;
            this.sequentialPrefetchBase$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchSpeed(double sequentialPrefetchSpeed) {
            this.sequentialPrefetchSpeed$value = sequentialPrefetchSpeed;
            this.sequentialPrefetchSpeed$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfiguration build() {
            int blobStoreCapacity$value = this.blobStoreCapacity$value;
            if (!this.blobStoreCapacity$set) {
                blobStoreCapacity$value = PhysicalIOConfiguration.$default$blobStoreCapacity();
            }
            int metadataStoreCapacity$value = this.metadataStoreCapacity$value;
            if (!this.metadataStoreCapacity$set) {
                metadataStoreCapacity$value = PhysicalIOConfiguration.$default$metadataStoreCapacity();
            }
            long blockSizeBytes$value = this.blockSizeBytes$value;
            if (!this.blockSizeBytes$set) {
                blockSizeBytes$value = PhysicalIOConfiguration.$default$blockSizeBytes();
            }
            long readAheadBytes$value = this.readAheadBytes$value;
            if (!this.readAheadBytes$set) {
                readAheadBytes$value = PhysicalIOConfiguration.$default$readAheadBytes();
            }
            long maxRangeSizeBytes$value = this.maxRangeSizeBytes$value;
            if (!this.maxRangeSizeBytes$set) {
                maxRangeSizeBytes$value = PhysicalIOConfiguration.$default$maxRangeSizeBytes();
            }
            long partSizeBytes$value = this.partSizeBytes$value;
            if (!this.partSizeBytes$set) {
                partSizeBytes$value = PhysicalIOConfiguration.$default$partSizeBytes();
            }
            double sequentialPrefetchBase$value = this.sequentialPrefetchBase$value;
            if (!this.sequentialPrefetchBase$set) {
                sequentialPrefetchBase$value = PhysicalIOConfiguration.$default$sequentialPrefetchBase();
            }
            double sequentialPrefetchSpeed$value = this.sequentialPrefetchSpeed$value;
            if (!this.sequentialPrefetchSpeed$set) {
                sequentialPrefetchSpeed$value = PhysicalIOConfiguration.$default$sequentialPrefetchSpeed();
            }
            return new PhysicalIOConfiguration(blobStoreCapacity$value, metadataStoreCapacity$value, blockSizeBytes$value, readAheadBytes$value, maxRangeSizeBytes$value, partSizeBytes$value, sequentialPrefetchBase$value, sequentialPrefetchSpeed$value);
        }

        @Generated
        public String toString() {
            return "PhysicalIOConfiguration.PhysicalIOConfigurationBuilder(blobStoreCapacity$value=" + this.blobStoreCapacity$value + ", metadataStoreCapacity$value=" + this.metadataStoreCapacity$value + ", blockSizeBytes$value=" + this.blockSizeBytes$value + ", readAheadBytes$value=" + this.readAheadBytes$value + ", maxRangeSizeBytes$value=" + this.maxRangeSizeBytes$value + ", partSizeBytes$value=" + this.partSizeBytes$value + ", sequentialPrefetchBase$value=" + this.sequentialPrefetchBase$value + ", sequentialPrefetchSpeed$value=" + this.sequentialPrefetchSpeed$value + ")";
        }
    }
}

