/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.request.Range;

public final class ParquetUtils {
    private ParquetUtils() {
    }

    public static Optional<Range> getFileTailRange(LogicalIOConfiguration logicalIOConfiguration, long startRange, long contentLength) {
        if (contentLength > logicalIOConfiguration.getFooterCachingSize()) {
            boolean shouldPrefetchSmallFile;
            boolean bl = shouldPrefetchSmallFile = logicalIOConfiguration.isSmallObjectsPrefetchingEnabled() && contentLength <= logicalIOConfiguration.getSmallObjectSizeThreshold();
            if (!shouldPrefetchSmallFile) {
                startRange = contentLength - logicalIOConfiguration.getFooterCachingSize();
            }
        }
        if (startRange < contentLength) {
            return Optional.of(new Range(startRange, contentLength - 1L));
        }
        return Optional.empty();
    }

    public static List<Integer> constructRowGroupsToPrefetch() {
        ArrayList<Integer> rowGroupsToPrefetch = new ArrayList<Integer>();
        rowGroupsToPrefetch.add(0);
        return rowGroupsToPrefetch;
    }

    public static List<Integer> constructRowGroupsToPrefetch(ColumnMetadata columnMetadata) {
        ArrayList<Integer> rowGroupsToPrefetch = new ArrayList<Integer>();
        rowGroupsToPrefetch.add(columnMetadata.getRowGroupIndex());
        return rowGroupsToPrefetch;
    }
}

