/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMappers;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetUtils;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanState;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.PrefetchMode;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class ParquetPredictivePrefetchingTask {
    private final S3URI s3Uri;
    private final Telemetry telemetry;
    private final PhysicalIO physicalIO;
    private final ParquetColumnPrefetchStore parquetColumnPrefetchStore;
    private final LogicalIOConfiguration logicalIOConfiguration;
    private static final String OPERATION_PARQUET_PREFETCH_COLUMNS = "parquet.task.prefetch.columns";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetPredictivePrefetchingTask.class);

    public ParquetPredictivePrefetchingTask(@NonNull S3URI s3Uri, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull PhysicalIO physicalIO, @NonNull ParquetColumnPrefetchStore parquetColumnPrefetchStore) {
        if (s3Uri == null) {
            throw new NullPointerException("s3Uri is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (parquetColumnPrefetchStore == null) {
            throw new NullPointerException("parquetColumnPrefetchStore is marked non-null but is null");
        }
        this.s3Uri = s3Uri;
        this.telemetry = telemetry;
        this.physicalIO = physicalIO;
        this.logicalIOConfiguration = logicalIOConfiguration;
        this.parquetColumnPrefetchStore = parquetColumnPrefetchStore;
    }

    public List<ColumnMetadata> addToRecentColumnList(long position, int len) {
        if (this.parquetColumnPrefetchStore.getColumnMappers(this.s3Uri) != null) {
            ColumnMappers columnMappers = this.parquetColumnPrefetchStore.getColumnMappers(this.s3Uri);
            if (columnMappers.getOffsetIndexToColumnMap().containsKey(position)) {
                ColumnMetadata columnMetadata = columnMappers.getOffsetIndexToColumnMap().get(position);
                this.parquetColumnPrefetchStore.addRecentColumn(columnMetadata);
                this.prefetchCurrentRowGroup(columnMappers, columnMetadata);
                List<ColumnMetadata> addedColumns = this.addAdjacentColumnsInLength(columnMetadata, columnMappers, position, len);
                addedColumns.add(columnMetadata);
                return addedColumns;
            }
            if ((long)len > 512000L) {
                return this.addCurrentColumnAtPosition(position, columnMappers);
            }
        }
        return Collections.emptyList();
    }

    private void prefetchCurrentRowGroup(ColumnMappers columnMappers, ColumnMetadata columnMetadata) {
        if (this.logicalIOConfiguration.getPrefetchingMode() == PrefetchMode.ROW_GROUP && !this.parquetColumnPrefetchStore.isRowGroupPrefetched(this.s3Uri, columnMetadata.getRowGroupIndex())) {
            this.prefetchRecentColumns(columnMappers, ParquetUtils.constructRowGroupsToPrefetch(columnMetadata));
            this.parquetColumnPrefetchStore.storePrefetchedRowGroupIndex(this.s3Uri, columnMetadata.getRowGroupIndex());
        }
    }

    public IOPlanExecution prefetchRecentColumns(ColumnMappers columnMappers, List<Integer> rowGroupsToPrefetch) {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_PREFETCH_COLUMNS)).attribute(StreamAttributes.uri(this.s3Uri))).build(), () -> {
            try {
                ArrayList<Range> prefetchRanges = new ArrayList<Range>();
                for (String recentColumn : this.getRecentColumns(columnMappers.getOffsetIndexToColumnMap())) {
                    if (!columnMappers.getColumnNameToColumnMap().containsKey(recentColumn)) continue;
                    LOG.debug("Column {} found in schema for {}, adding to prefetch list", (Object)recentColumn, (Object)this.s3Uri.getKey());
                    List<ColumnMetadata> columnMetadataList = columnMappers.getColumnNameToColumnMap().get(recentColumn);
                    for (ColumnMetadata columnMetadata : columnMetadataList) {
                        if (!rowGroupsToPrefetch.contains(columnMetadata.getRowGroupIndex())) continue;
                        prefetchRanges.add(new Range(columnMetadata.getStartPos(), columnMetadata.getStartPos() + columnMetadata.getCompressedSize() - 1L));
                    }
                }
                IOPlan ioPlan = prefetchRanges.isEmpty() ? IOPlan.EMPTY_PLAN : new IOPlan(prefetchRanges);
                return this.physicalIO.execute(ioPlan);
            }
            catch (Exception e) {
                LOG.warn("Unable to prefetch columns for {}.", (Object)this.s3Uri.getKey(), (Object)e);
                return IOPlanExecution.builder().state(IOPlanState.SKIPPED).build();
            }
        });
    }

    private List<ColumnMetadata> addCurrentColumnAtPosition(long position, ColumnMappers columnMappers) {
        ArrayList<Long> columnPositions = new ArrayList<Long>(columnMappers.getOffsetIndexToColumnMap().keySet());
        Collections.sort(columnPositions);
        long lastColumnStartPos = columnPositions.get(columnPositions.size() - 1);
        ColumnMetadata lastColumnMetadata = columnMappers.getOffsetIndexToColumnMap().get(lastColumnStartPos);
        columnPositions.add(lastColumnStartPos + lastColumnMetadata.getCompressedSize());
        for (int i = 0; i < columnPositions.size() - 1; ++i) {
            if (position <= columnPositions.get(i) || position >= columnPositions.get(i + 1)) continue;
            ColumnMetadata currentColumnMetadata = columnMappers.getOffsetIndexToColumnMap().get(columnPositions.get(i));
            this.parquetColumnPrefetchStore.addRecentColumn(currentColumnMetadata);
            ArrayList<ColumnMetadata> addedColumns = new ArrayList<ColumnMetadata>();
            addedColumns.add(currentColumnMetadata);
            return addedColumns;
        }
        return Collections.emptyList();
    }

    private List<ColumnMetadata> addAdjacentColumnsInLength(ColumnMetadata columnMetadata, ColumnMappers columnMappers, long position, int len) {
        ArrayList<ColumnMetadata> addedColumns = new ArrayList<ColumnMetadata>();
        if ((long)len > columnMetadata.getCompressedSize() && (long)len > 512000L) {
            ColumnMetadata currentColumnMetadata;
            long remainingLen = (long)len - columnMetadata.getCompressedSize();
            long currentPos = position + columnMetadata.getCompressedSize();
            while (remainingLen > 0L && (currentColumnMetadata = columnMappers.getOffsetIndexToColumnMap().get(currentPos)) != null && columnMetadata.getCompressedSize() != 0L) {
                this.parquetColumnPrefetchStore.addRecentColumn(currentColumnMetadata);
                remainingLen -= currentColumnMetadata.getCompressedSize();
                currentPos += currentColumnMetadata.getCompressedSize();
                addedColumns.add(currentColumnMetadata);
            }
        }
        return addedColumns;
    }

    private Set<String> getRecentColumns(Map<Long, ColumnMetadata> offsetIndexToColumnMap) {
        if (!offsetIndexToColumnMap.isEmpty()) {
            Map.Entry<Long, ColumnMetadata> firstColumnData = offsetIndexToColumnMap.entrySet().iterator().next();
            int schemaHash = firstColumnData.getValue().getSchemaHash();
            return this.parquetColumnPrefetchStore.getUniqueRecentColumnsForSchema(schemaHash);
        }
        return Collections.emptySet();
    }
}

