/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMappers;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMetadata;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="The closure classes trigger this. We never use serialization on this class")
public class ParquetColumnPrefetchStore {
    private final Map<S3URI, ColumnMappers> columnMappersStore;
    private final Map<Integer, LinkedList<String>> recentlyReadColumnsPerSchema;
    private final Map<S3URI, List<Integer>> rowGroupsPrefetched;
    private final LogicalIOConfiguration configuration;

    public ParquetColumnPrefetchStore(final LogicalIOConfiguration configuration) {
        this(configuration, (Map<S3URI, ColumnMappers>)new LinkedHashMap<S3URI, ColumnMappers>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<S3URI, ColumnMappers> eldest) {
                return this.size() > configuration.getParquetMetadataStoreSize();
            }
        }, (Map<Integer, LinkedList<String>>)new LinkedHashMap<Integer, LinkedList<String>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, LinkedList<String>> eldest) {
                return this.size() > configuration.getMaxColumnAccessCountStoreSize();
            }
        }, (Map<S3URI, List<Integer>>)new LinkedHashMap<S3URI, List<Integer>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<S3URI, List<Integer>> eldest) {
                return this.size() > configuration.getParquetMetadataStoreSize();
            }
        });
    }

    ParquetColumnPrefetchStore(LogicalIOConfiguration configuration, Map<S3URI, ColumnMappers> columnMappersStore, Map<Integer, LinkedList<String>> recentlyReadColumnsPerSchema, Map<S3URI, List<Integer>> rowGroupsPrefetched) {
        this.configuration = configuration;
        this.columnMappersStore = columnMappersStore;
        this.recentlyReadColumnsPerSchema = recentlyReadColumnsPerSchema;
        this.rowGroupsPrefetched = rowGroupsPrefetched;
    }

    public synchronized ColumnMappers getColumnMappers(S3URI s3URI) {
        return this.columnMappersStore.get(s3URI);
    }

    public synchronized void putColumnMappers(S3URI s3URI, ColumnMappers columnMappers) {
        this.columnMappersStore.put(s3URI, columnMappers);
    }

    public synchronized void addRecentColumn(ColumnMetadata columnMetadata) {
        LinkedList<String> schemaRecentColumns = this.recentlyReadColumnsPerSchema.getOrDefault(columnMetadata.getSchemaHash(), new LinkedList());
        if (schemaRecentColumns.size() == this.configuration.getMaxColumnAccessCountStoreSize()) {
            schemaRecentColumns.removeFirst();
        }
        schemaRecentColumns.add(columnMetadata.getColumnName());
        this.recentlyReadColumnsPerSchema.put(columnMetadata.getSchemaHash(), schemaRecentColumns);
    }

    public synchronized Set<String> getUniqueRecentColumnsForSchema(int schemaHash) {
        List schemaRecentColumns = this.recentlyReadColumnsPerSchema.get(schemaHash);
        if (schemaRecentColumns != null) {
            return new HashSet<String>(schemaRecentColumns);
        }
        return Collections.emptySet();
    }

    public synchronized boolean isRowGroupPrefetched(S3URI s3URI, Integer rowGroupIndex) {
        List<Integer> rowGroupsPrefetchedForKey = this.rowGroupsPrefetched.get(s3URI);
        if (rowGroupsPrefetchedForKey == null) {
            return false;
        }
        return rowGroupsPrefetchedForKey.contains(rowGroupIndex);
    }

    public synchronized void storePrefetchedRowGroupIndex(S3URI s3URI, Integer rowGroupIndex) {
        List rowGroupsPrefetchedForKey = this.rowGroupsPrefetched.getOrDefault(s3URI, new ArrayList());
        rowGroupsPrefetchedForKey.add(rowGroupIndex);
        this.rowGroupsPrefetched.put(s3URI, rowGroupsPrefetchedForKey);
    }
}

