/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.util.PrefetchMode;

public class LogicalIOConfiguration {
    private static final boolean DEFAULT_FOOTER_CACHING_ENABLED = true;
    private static final long DEFAULT_FOOTER_CACHING_SIZE = 0x100000L;
    private static final boolean DEFAULT_SMALL_OBJECT_PREFETCHING_ENABLED = true;
    private static final long DEFAULT_SMALL_OBJECT_SIZE_THRESHOLD = 0x300000L;
    private static final int DEFAULT_PARQUET_METADATA_STORE_SIZE = 45;
    private static final int DEFAULT_MAX_COLUMN_ACCESS_STORE_SIZE = 15;
    private static final String DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX = "^.*.(parquet|par)$";
    private static final PrefetchMode DEFAULT_PREFETCHING_MODE = PrefetchMode.ROW_GROUP;
    private boolean footerCachingEnabled;
    private static final String FOOTER_CACHING_ENABLED_KEY = "footer.caching.enabled";
    private long footerCachingSize;
    private static final String FOOTER_CACHING_SIZE_KEY = "footer.caching.size";
    private boolean smallObjectsPrefetchingEnabled;
    private static final String SMALL_OBJECTS_PREFETCHING_ENABLED_KEY = "small.objects.prefetching.enabled";
    private long smallObjectSizeThreshold;
    private static final String SMALL_OBJECT_SIZE_THRESHOLD_KEY = "small.object.size.threshold";
    private static final String METADATA_AWARE_PREFETCHING_ENABLED_KEY = "metadata.aware.prefetching.enabled";
    private PrefetchMode prefetchingMode;
    private static final String PREFETCHING_MODE_KEY = "prefetching.mode";
    private int parquetMetadataStoreSize;
    private static final String PARQUET_METADATA_STORE_SIZE_KEY = "parquet.metadata.store.size";
    private int maxColumnAccessCountStoreSize;
    private static final String MAX_COLUMN_ACCESS_STORE_SIZE_KEY = "max.column.access.store.size";
    private String parquetFormatSelectorRegex;
    private static final String PARQUET_FORMAT_SELECTOR_REGEX = "parquet.format.selector.regex";
    public static final LogicalIOConfiguration DEFAULT = LogicalIOConfiguration.builder().build();

    public static LogicalIOConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return LogicalIOConfiguration.builder().footerCachingEnabled(configuration.getBoolean(FOOTER_CACHING_ENABLED_KEY, true)).footerCachingSize(configuration.getLong(FOOTER_CACHING_SIZE_KEY, 0x100000L)).smallObjectsPrefetchingEnabled(configuration.getBoolean(SMALL_OBJECTS_PREFETCHING_ENABLED_KEY, true)).smallObjectSizeThreshold(configuration.getLong(SMALL_OBJECT_SIZE_THRESHOLD_KEY, 0x300000L)).parquetMetadataStoreSize(configuration.getInt(PARQUET_METADATA_STORE_SIZE_KEY, 45)).maxColumnAccessCountStoreSize(configuration.getInt(MAX_COLUMN_ACCESS_STORE_SIZE_KEY, 15)).parquetFormatSelectorRegex(configuration.getString(PARQUET_FORMAT_SELECTOR_REGEX, DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX)).prefetchingMode(PrefetchMode.fromString(configuration.getString(PREFETCHING_MODE_KEY, DEFAULT_PREFETCHING_MODE.toString()))).build();
    }

    @Generated
    private static boolean $default$footerCachingEnabled() {
        return true;
    }

    @Generated
    private static long $default$footerCachingSize() {
        return 0x100000L;
    }

    @Generated
    private static boolean $default$smallObjectsPrefetchingEnabled() {
        return true;
    }

    @Generated
    private static long $default$smallObjectSizeThreshold() {
        return 0x300000L;
    }

    @Generated
    private static PrefetchMode $default$prefetchingMode() {
        return DEFAULT_PREFETCHING_MODE;
    }

    @Generated
    private static int $default$parquetMetadataStoreSize() {
        return 45;
    }

    @Generated
    private static int $default$maxColumnAccessCountStoreSize() {
        return 15;
    }

    @Generated
    private static String $default$parquetFormatSelectorRegex() {
        return DEFAULT_PARQUET_FORMAT_SELECTOR_REGEX;
    }

    @Generated
    LogicalIOConfiguration(boolean footerCachingEnabled, long footerCachingSize, boolean smallObjectsPrefetchingEnabled, long smallObjectSizeThreshold, PrefetchMode prefetchingMode, int parquetMetadataStoreSize, int maxColumnAccessCountStoreSize, String parquetFormatSelectorRegex) {
        this.footerCachingEnabled = footerCachingEnabled;
        this.footerCachingSize = footerCachingSize;
        this.smallObjectsPrefetchingEnabled = smallObjectsPrefetchingEnabled;
        this.smallObjectSizeThreshold = smallObjectSizeThreshold;
        this.prefetchingMode = prefetchingMode;
        this.parquetMetadataStoreSize = parquetMetadataStoreSize;
        this.maxColumnAccessCountStoreSize = maxColumnAccessCountStoreSize;
        this.parquetFormatSelectorRegex = parquetFormatSelectorRegex;
    }

    @Generated
    public static LogicalIOConfigurationBuilder builder() {
        return new LogicalIOConfigurationBuilder();
    }

    @Generated
    public boolean isFooterCachingEnabled() {
        return this.footerCachingEnabled;
    }

    @Generated
    public long getFooterCachingSize() {
        return this.footerCachingSize;
    }

    @Generated
    public boolean isSmallObjectsPrefetchingEnabled() {
        return this.smallObjectsPrefetchingEnabled;
    }

    @Generated
    public long getSmallObjectSizeThreshold() {
        return this.smallObjectSizeThreshold;
    }

    @Generated
    public PrefetchMode getPrefetchingMode() {
        return this.prefetchingMode;
    }

    @Generated
    public int getParquetMetadataStoreSize() {
        return this.parquetMetadataStoreSize;
    }

    @Generated
    public int getMaxColumnAccessCountStoreSize() {
        return this.maxColumnAccessCountStoreSize;
    }

    @Generated
    public String getParquetFormatSelectorRegex() {
        return this.parquetFormatSelectorRegex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogicalIOConfiguration)) {
            return false;
        }
        LogicalIOConfiguration other = (LogicalIOConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFooterCachingEnabled() != other.isFooterCachingEnabled()) {
            return false;
        }
        if (this.getFooterCachingSize() != other.getFooterCachingSize()) {
            return false;
        }
        if (this.isSmallObjectsPrefetchingEnabled() != other.isSmallObjectsPrefetchingEnabled()) {
            return false;
        }
        if (this.getSmallObjectSizeThreshold() != other.getSmallObjectSizeThreshold()) {
            return false;
        }
        if (this.getParquetMetadataStoreSize() != other.getParquetMetadataStoreSize()) {
            return false;
        }
        if (this.getMaxColumnAccessCountStoreSize() != other.getMaxColumnAccessCountStoreSize()) {
            return false;
        }
        PrefetchMode this$prefetchingMode = this.getPrefetchingMode();
        PrefetchMode other$prefetchingMode = other.getPrefetchingMode();
        if (this$prefetchingMode == null ? other$prefetchingMode != null : !((Object)((Object)this$prefetchingMode)).equals((Object)other$prefetchingMode)) {
            return false;
        }
        String this$parquetFormatSelectorRegex = this.getParquetFormatSelectorRegex();
        String other$parquetFormatSelectorRegex = other.getParquetFormatSelectorRegex();
        return !(this$parquetFormatSelectorRegex == null ? other$parquetFormatSelectorRegex != null : !this$parquetFormatSelectorRegex.equals(other$parquetFormatSelectorRegex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogicalIOConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFooterCachingEnabled() ? 79 : 97);
        long $footerCachingSize = this.getFooterCachingSize();
        result = result * 59 + (int)($footerCachingSize >>> 32 ^ $footerCachingSize);
        result = result * 59 + (this.isSmallObjectsPrefetchingEnabled() ? 79 : 97);
        long $smallObjectSizeThreshold = this.getSmallObjectSizeThreshold();
        result = result * 59 + (int)($smallObjectSizeThreshold >>> 32 ^ $smallObjectSizeThreshold);
        result = result * 59 + this.getParquetMetadataStoreSize();
        result = result * 59 + this.getMaxColumnAccessCountStoreSize();
        PrefetchMode $prefetchingMode = this.getPrefetchingMode();
        result = result * 59 + ($prefetchingMode == null ? 43 : ((Object)((Object)$prefetchingMode)).hashCode());
        String $parquetFormatSelectorRegex = this.getParquetFormatSelectorRegex();
        result = result * 59 + ($parquetFormatSelectorRegex == null ? 43 : $parquetFormatSelectorRegex.hashCode());
        return result;
    }

    @Generated
    public static class LogicalIOConfigurationBuilder {
        @Generated
        private boolean footerCachingEnabled$set;
        @Generated
        private boolean footerCachingEnabled$value;
        @Generated
        private boolean footerCachingSize$set;
        @Generated
        private long footerCachingSize$value;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$set;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$value;
        @Generated
        private boolean smallObjectSizeThreshold$set;
        @Generated
        private long smallObjectSizeThreshold$value;
        @Generated
        private boolean prefetchingMode$set;
        @Generated
        private PrefetchMode prefetchingMode$value;
        @Generated
        private boolean parquetMetadataStoreSize$set;
        @Generated
        private int parquetMetadataStoreSize$value;
        @Generated
        private boolean maxColumnAccessCountStoreSize$set;
        @Generated
        private int maxColumnAccessCountStoreSize$value;
        @Generated
        private boolean parquetFormatSelectorRegex$set;
        @Generated
        private String parquetFormatSelectorRegex$value;

        @Generated
        LogicalIOConfigurationBuilder() {
        }

        @Generated
        public LogicalIOConfigurationBuilder footerCachingEnabled(boolean footerCachingEnabled) {
            this.footerCachingEnabled$value = footerCachingEnabled;
            this.footerCachingEnabled$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder footerCachingSize(long footerCachingSize) {
            this.footerCachingSize$value = footerCachingSize;
            this.footerCachingSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder smallObjectsPrefetchingEnabled(boolean smallObjectsPrefetchingEnabled) {
            this.smallObjectsPrefetchingEnabled$value = smallObjectsPrefetchingEnabled;
            this.smallObjectsPrefetchingEnabled$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder smallObjectSizeThreshold(long smallObjectSizeThreshold) {
            this.smallObjectSizeThreshold$value = smallObjectSizeThreshold;
            this.smallObjectSizeThreshold$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder prefetchingMode(PrefetchMode prefetchingMode) {
            this.prefetchingMode$value = prefetchingMode;
            this.prefetchingMode$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder parquetMetadataStoreSize(int parquetMetadataStoreSize) {
            this.parquetMetadataStoreSize$value = parquetMetadataStoreSize;
            this.parquetMetadataStoreSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder maxColumnAccessCountStoreSize(int maxColumnAccessCountStoreSize) {
            this.maxColumnAccessCountStoreSize$value = maxColumnAccessCountStoreSize;
            this.maxColumnAccessCountStoreSize$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfigurationBuilder parquetFormatSelectorRegex(String parquetFormatSelectorRegex) {
            this.parquetFormatSelectorRegex$value = parquetFormatSelectorRegex;
            this.parquetFormatSelectorRegex$set = true;
            return this;
        }

        @Generated
        public LogicalIOConfiguration build() {
            boolean footerCachingEnabled$value = this.footerCachingEnabled$value;
            if (!this.footerCachingEnabled$set) {
                footerCachingEnabled$value = LogicalIOConfiguration.$default$footerCachingEnabled();
            }
            long footerCachingSize$value = this.footerCachingSize$value;
            if (!this.footerCachingSize$set) {
                footerCachingSize$value = LogicalIOConfiguration.$default$footerCachingSize();
            }
            boolean smallObjectsPrefetchingEnabled$value = this.smallObjectsPrefetchingEnabled$value;
            if (!this.smallObjectsPrefetchingEnabled$set) {
                smallObjectsPrefetchingEnabled$value = LogicalIOConfiguration.$default$smallObjectsPrefetchingEnabled();
            }
            long smallObjectSizeThreshold$value = this.smallObjectSizeThreshold$value;
            if (!this.smallObjectSizeThreshold$set) {
                smallObjectSizeThreshold$value = LogicalIOConfiguration.$default$smallObjectSizeThreshold();
            }
            PrefetchMode prefetchingMode$value = this.prefetchingMode$value;
            if (!this.prefetchingMode$set) {
                prefetchingMode$value = LogicalIOConfiguration.$default$prefetchingMode();
            }
            int parquetMetadataStoreSize$value = this.parquetMetadataStoreSize$value;
            if (!this.parquetMetadataStoreSize$set) {
                parquetMetadataStoreSize$value = LogicalIOConfiguration.$default$parquetMetadataStoreSize();
            }
            int maxColumnAccessCountStoreSize$value = this.maxColumnAccessCountStoreSize$value;
            if (!this.maxColumnAccessCountStoreSize$set) {
                maxColumnAccessCountStoreSize$value = LogicalIOConfiguration.$default$maxColumnAccessCountStoreSize();
            }
            String parquetFormatSelectorRegex$value = this.parquetFormatSelectorRegex$value;
            if (!this.parquetFormatSelectorRegex$set) {
                parquetFormatSelectorRegex$value = LogicalIOConfiguration.$default$parquetFormatSelectorRegex();
            }
            return new LogicalIOConfiguration(footerCachingEnabled$value, footerCachingSize$value, smallObjectsPrefetchingEnabled$value, smallObjectSizeThreshold$value, prefetchingMode$value, parquetMetadataStoreSize$value, maxColumnAccessCountStoreSize$value, parquetFormatSelectorRegex$value);
        }

        @Generated
        public String toString() {
            return "LogicalIOConfiguration.LogicalIOConfigurationBuilder(footerCachingEnabled$value=" + this.footerCachingEnabled$value + ", footerCachingSize$value=" + this.footerCachingSize$value + ", smallObjectsPrefetchingEnabled$value=" + this.smallObjectsPrefetchingEnabled$value + ", smallObjectSizeThreshold$value=" + this.smallObjectSizeThreshold$value + ", prefetchingMode$value=" + (Object)((Object)this.prefetchingMode$value) + ", parquetMetadataStoreSize$value=" + this.parquetMetadataStoreSize$value + ", maxColumnAccessCountStoreSize$value=" + this.maxColumnAccessCountStoreSize$value + ", parquetFormatSelectorRegex$value=" + this.parquetFormatSelectorRegex$value + ")";
        }
    }
}

