/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.ConfigurableTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultElapsedClock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultEpochClock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Metric;
import software.amazon.s3.analyticsaccelerator.common.telemetry.NoOpTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationSupplier;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryAction;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetrySupplier;

public interface Telemetry
extends Closeable {
    public static final Telemetry NOOP = new DefaultTelemetry(DefaultEpochClock.DEFAULT, DefaultElapsedClock.DEFAULT, new NoOpTelemetryReporter(), Optional.empty(), TelemetryLevel.CRITICAL);

    public void measure(@NonNull TelemetryLevel var1, @NonNull OperationSupplier var2, @NonNull TelemetryAction var3);

    public <T> T measure(@NonNull TelemetryLevel var1, @NonNull OperationSupplier var2, @NonNull TelemetrySupplier<T> var3);

    public <T> CompletableFuture<T> measure(@NonNull TelemetryLevel var1, @NonNull OperationSupplier var2, @NonNull CompletableFuture<T> var3);

    default public <T> T measureJoin(@NonNull TelemetryLevel level, @NonNull OperationSupplier operationSupplier, @NonNull CompletableFuture<T> operationCode) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (operationSupplier == null) {
            throw new NullPointerException("operationSupplier is marked non-null but is null");
        }
        if (operationCode == null) {
            throw new NullPointerException("operationCode is marked non-null but is null");
        }
        if (operationCode.isDone()) {
            return operationCode.join();
        }
        return (T)this.measure(level, operationSupplier, operationCode::join);
    }

    default public void measureCritical(OperationSupplier operationSupplier, TelemetryAction operationCode) {
        this.measure(TelemetryLevel.CRITICAL, operationSupplier, operationCode);
    }

    default public <T> T measureCritical(OperationSupplier operationSupplier, TelemetrySupplier<T> operationCode) {
        return this.measure(TelemetryLevel.CRITICAL, operationSupplier, operationCode);
    }

    default public <T> CompletableFuture<T> measureCritical(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measure(TelemetryLevel.CRITICAL, operationSupplier, operationCode);
    }

    default public <T> T measureJoinCritical(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measureJoin(TelemetryLevel.CRITICAL, operationSupplier, operationCode);
    }

    default public void measureStandard(OperationSupplier operationSupplier, TelemetryAction operationCode) {
        this.measure(TelemetryLevel.STANDARD, operationSupplier, operationCode);
    }

    default public <T> T measureStandard(OperationSupplier operationSupplier, TelemetrySupplier<T> operationCode) {
        return this.measure(TelemetryLevel.STANDARD, operationSupplier, operationCode);
    }

    default public <T> CompletableFuture<T> measureStandard(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measure(TelemetryLevel.STANDARD, operationSupplier, operationCode);
    }

    default public <T> T measureJoinStandard(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measureJoin(TelemetryLevel.STANDARD, operationSupplier, operationCode);
    }

    default public void measureVerbose(OperationSupplier operationSupplier, TelemetryAction operationCode) {
        this.measure(TelemetryLevel.VERBOSE, operationSupplier, operationCode);
    }

    default public <T> T measureVerbose(OperationSupplier operationSupplier, TelemetrySupplier<T> operationCode) {
        return this.measure(TelemetryLevel.VERBOSE, operationSupplier, operationCode);
    }

    default public <T> CompletableFuture<T> measureVerbose(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measure(TelemetryLevel.VERBOSE, operationSupplier, operationCode);
    }

    default public <T> T measureJoinVerbose(OperationSupplier operationSupplier, CompletableFuture<T> operationCode) {
        return this.measureJoin(TelemetryLevel.VERBOSE, operationSupplier, operationCode);
    }

    public <T> T measureConditionally(TelemetryLevel var1, OperationSupplier var2, TelemetrySupplier<T> var3, Predicate<T> var4);

    public void measure(@NonNull Metric var1, double var2);

    public void flush();

    @Override
    default public void close() {
        this.flush();
    }

    public static Telemetry createTelemetry(@NonNull TelemetryConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return new ConfigurableTelemetry(configuration);
    }
}

