/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;

public final class ConnectorConfiguration {
    private final String prefix;
    private final Map<String, String> configuration;

    public ConnectorConfiguration(@NonNull Map<String, String> configurationMap) {
        this(configurationMap, "");
        if (configurationMap == null) {
            throw new NullPointerException("configurationMap is marked non-null but is null");
        }
    }

    public ConnectorConfiguration(@NonNull Map<String, String> configurationMap, @NonNull String prefix) {
        this(configurationMap.entrySet(), prefix);
        if (configurationMap == null) {
            throw new NullPointerException("configurationMap is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
    }

    public ConnectorConfiguration(@NonNull Iterable<Map.Entry<String, String>> iterableConfiguration, @NonNull String prefix) {
        if (iterableConfiguration == null) {
            throw new NullPointerException("iterableConfiguration is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
        this.configuration = StreamSupport.stream(iterableConfiguration.spliterator(), false).filter(entry -> ((String)entry.getKey()).startsWith(this.getPrefix())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ConnectorConfiguration map(@NonNull String appendPrefix) {
        if (appendPrefix == null) {
            throw new NullPointerException("appendPrefix is marked non-null but is null");
        }
        return new ConnectorConfiguration(this.configuration, this.expandKey(appendPrefix));
    }

    public int getInt(@NonNull String key, int defaultValue) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Integer::parseInt, () -> defaultValue);
    }

    public int getRequiredInt(@NonNull String key) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Integer::parseInt, () -> (Integer)ConnectorConfiguration.throwIfNotPresent(key));
    }

    public long getLong(@NonNull String key, long defaultValue) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Long::parseLong, () -> defaultValue);
    }

    public long getRequiredLong(@NonNull String key) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Long::parseLong, () -> (Long)ConnectorConfiguration.throwIfNotPresent(key));
    }

    public String getString(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Function.identity(), () -> defaultValue);
    }

    public String getRequiredString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Function.identity(), () -> (String)ConnectorConfiguration.throwIfNotPresent(key));
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Boolean::parseBoolean, () -> defaultValue);
    }

    public boolean getRequiredBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Boolean::parseBoolean, () -> (Boolean)ConnectorConfiguration.throwIfNotPresent(key));
    }

    public double getDouble(@NonNull String key, double defaultValue) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Double::parseDouble, () -> defaultValue);
    }

    public double getRequiredDouble(@NonNull String key) throws NumberFormatException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getValue(key, Double::parseDouble, () -> (Double)ConnectorConfiguration.throwIfNotPresent(key));
    }

    private <T> T getValue(@NonNull String key, Function<String, T> caster, Supplier<T> defaultValueSupplier) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.configuration.get(this.expandKey(key));
        return value != null ? caster.apply(value) : defaultValueSupplier.get();
    }

    private static <T> T throwIfNotPresent(String key) {
        throw new IllegalArgumentException(String.format("Required configuration '%s' is not set.", key));
    }

    private String expandKey(String key) {
        if (this.prefix.isEmpty()) {
            return key;
        }
        return this.prefix + '.' + key;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }
}

