/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.s3.analyticsaccelerator.ObjectClientConfiguration;
import software.amazon.s3.analyticsaccelerator.ObjectClientTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.ConfigurableTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.UserAgent;

public class S3SdkObjectClient
implements ObjectClient {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_REFERER = "Referer";
    @NonNull
    private final S3AsyncClient s3AsyncClient;
    @NonNull
    private final Telemetry telemetry;
    @NonNull
    private final UserAgent userAgent;
    private final boolean closeAsyncClient;

    public S3SdkObjectClient(S3AsyncClient s3AsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT);
    }

    public S3SdkObjectClient(S3AsyncClient s3AsyncClient, boolean closeAsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT, closeAsyncClient);
    }

    public S3SdkObjectClient(S3AsyncClient s3AsyncClient, ObjectClientConfiguration objectClientConfiguration) {
        this(s3AsyncClient, objectClientConfiguration, true);
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, @NonNull ObjectClientConfiguration objectClientConfiguration, boolean closeAsyncClient) {
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
        if (objectClientConfiguration == null) {
            throw new NullPointerException("objectClientConfiguration is marked non-null but is null");
        }
        this.s3AsyncClient = s3AsyncClient;
        this.closeAsyncClient = closeAsyncClient;
        this.telemetry = new ConfigurableTelemetry(objectClientConfiguration.getTelemetryConfiguration());
        this.userAgent = new UserAgent();
        this.userAgent.prepend(objectClientConfiguration.getUserAgentPrefix());
    }

    @Override
    public void close() {
        if (this.closeAsyncClient) {
            this.s3AsyncClient.close();
        }
    }

    @Override
    public CompletableFuture<ObjectMetadata> headObject(HeadRequest headRequest) {
        HeadObjectRequest.Builder builder = HeadObjectRequest.builder().bucket(headRequest.getS3Uri().getBucket()).key(headRequest.getS3Uri().getKey());
        builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader(HEADER_USER_AGENT, this.userAgent.getUserAgent())).build());
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.head")).attribute(ObjectClientTelemetry.uri(headRequest.getS3Uri()))).build(), this.s3AsyncClient.headObject((HeadObjectRequest)builder.build()).thenApply(headObjectResponse -> ObjectMetadata.builder().contentLength(headObjectResponse.contentLength()).build()));
    }

    @Override
    public CompletableFuture<ObjectContent> getObject(GetRequest getRequest) {
        GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(getRequest.getS3Uri().getBucket()).key(getRequest.getS3Uri().getKey());
        String range = getRequest.getRange().toHttpString();
        builder.range(range);
        builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader(HEADER_REFERER, getRequest.getReferrer().toString())).putHeader(HEADER_USER_AGENT, this.userAgent.getUserAgent())).build());
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.get")).attribute(ObjectClientTelemetry.uri(getRequest.getS3Uri()))).attribute(ObjectClientTelemetry.rangeLength(getRequest.getRange()))).attribute(ObjectClientTelemetry.range(getRequest.getRange()))).build(), this.s3AsyncClient.getObject((GetObjectRequest)builder.build(), AsyncResponseTransformer.toBlockingInputStream()).thenApply(responseInputStream -> ObjectContent.builder().stream((InputStream)responseInputStream).build()));
    }

    @NonNull
    @Generated
    public S3AsyncClient getS3AsyncClient() {
        return this.s3AsyncClient;
    }
}

