/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.plugin;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsUtils;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;

public class S3AccessGrantsAuthSchemeProvider
implements S3AuthSchemeProvider {
    private final S3AuthSchemeProvider authSchemeProvider;

    S3AccessGrantsAuthSchemeProvider(@NotNull S3AuthSchemeProvider authSchemeProvider) {
        S3AccessGrantsUtils.argumentNotNull(authSchemeProvider, "Expecting an Auth Scheme Provider to be specified while configuring S3Clients!");
        this.authSchemeProvider = authSchemeProvider;
    }

    public List<AuthSchemeOption> resolveAuthScheme(@NotNull S3AuthSchemeParams authSchemeParams) {
        S3AccessGrantsUtils.argumentNotNull(authSchemeParams, "An internal exception has occurred. Valid auth scheme params were not passed to the Auth Scheme Provider. Please contact the S3 Access Grants plugin team!");
        List availableAuthSchemes = this.authSchemeProvider.resolveAuthScheme(authSchemeParams);
        String S3Prefix = "s3://" + authSchemeParams.bucket() + "/" + this.getKeyIfExists(authSchemeParams);
        return availableAuthSchemes.stream().map(authScheme -> (AuthSchemeOption)((AuthSchemeOption.Builder)authScheme.toBuilder()).putIdentityProperty(S3AccessGrantsUtils.OPERATION_PROPERTY, (Object)authSchemeParams.operation()).putIdentityProperty(S3AccessGrantsUtils.PREFIX_PROPERTY, (Object)S3Prefix).build()).collect(Collectors.toList());
    }

    private String getKeyIfExists(S3AuthSchemeParams authSchemeParams) {
        String validKey;
        Boolean keyDoesNotExists = !(authSchemeParams.key() != null && !authSchemeParams.key().isEmpty() || authSchemeParams.prefix() != null && !authSchemeParams.prefix().isEmpty());
        String string = authSchemeParams.key() != null && !authSchemeParams.key().isEmpty() ? authSchemeParams.key() : (validKey = authSchemeParams.prefix() != null && !authSchemeParams.prefix().isEmpty() ? authSchemeParams.prefix() : null);
        if (keyDoesNotExists.booleanValue()) {
            S3AccessGrantsUtils.logger.debug(() -> "no object key was specified for the operation!");
        }
        return keyDoesNotExists != false ? "*" : validKey;
    }
}

