/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonReaderBuilder;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.qldb.BufferedResult;
import software.amazon.qldb.Result;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class TableNameIterable
implements Iterable<String> {
    private static final Logger logger = LoggerFactory.getLogger(TableNameIterable.class);
    private final Iterable<IonValue> iteratorSeed;

    TableNameIterable(Result result) {
        if (!(result instanceof BufferedResult)) {
            result = new BufferedResult(result);
        }
        this.iteratorSeed = result;
    }

    @Override
    public Iterator<String> iterator() {
        return new TableNameIterator(this.iteratorSeed.iterator());
    }

    private static class TableNameIterator
    implements Iterator<String> {
        private final Iterator<IonValue> nameResultIterator;

        TableNameIterator(Iterator<IonValue> nameResultIterator) {
            this.nameResultIterator = nameResultIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nameResultIterator.hasNext();
        }

        @Override
        public String next() {
            IonReader reader = IonReaderBuilder.standard().build(this.nameResultIterator.next());
            IonType type = reader.next();
            if (IonType.STRING != type) {
                String message = String.format(Errors.INCORRECT_TYPE.get(), IonType.STRING, type);
                logger.error(message);
                throw new IllegalStateException(message);
            }
            return reader.stringValue();
        }
    }
}

