/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.Session;
import software.amazon.qldb.exceptions.Errors;

abstract class BaseQldbSession {
    static final String TABLE_NAME_QUERY = "SELECT VALUE name FROM information_schema.user_tables WHERE status = 'ACTIVE'";
    private static final Logger logger = LoggerFactory.getLogger(BaseQldbSession.class);
    private static final long SLEEP_BASE_MS = 10L;
    private static final long SLEEP_CAP_MS = 5000L;
    final int retryLimit;
    Session session;
    final AtomicBoolean isClosed = new AtomicBoolean(true);
    final IonSystem ionSystem;

    BaseQldbSession(Session session, int retryLimit, IonSystem ionSystem) {
        this.retryLimit = retryLimit;
        this.ionSystem = ionSystem;
        this.session = session;
        this.isClosed.set(false);
    }

    public String getLedgerName() {
        return this.session.getLedgerName();
    }

    public String getSessionToken() {
        return this.session.getToken();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    static void retrySleep(int attemptNumber) {
        try {
            double jitterRand = Math.random();
            double exponentialBackoff = Math.min(5000L, (long)Math.pow(10.0, attemptNumber));
            Thread.sleep((long)(jitterRand * (exponentialBackoff + 1.0)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void throwIfClosed() {
        if (this.isClosed.get()) {
            logger.error(Errors.SESSION_CLOSED.get());
            throw new IllegalStateException(Errors.SESSION_CLOSED.get());
        }
    }
}

