/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.util.ValidationUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.qldb.BaseQldbSession;
import software.amazon.qldb.QldbHash;
import software.amazon.qldb.Session;

abstract class BaseTransaction
implements AutoCloseable {
    final BaseQldbSession qldbSession;
    final Session session;
    final String txnId;
    final AtomicBoolean isClosed = new AtomicBoolean(true);
    private QldbHash txnHash;
    final IonSystem ionSystem;

    BaseTransaction(BaseQldbSession qldbSession, String txnId, IonSystem ionSystem) {
        ValidationUtils.assertNotNull((Object)qldbSession, (String)"qldbSession");
        ValidationUtils.assertNotNull((Object)txnId, (String)"txnId");
        this.qldbSession = qldbSession;
        this.session = qldbSession.session;
        this.txnId = txnId;
        this.txnHash = QldbHash.toQldbHash(this.txnId, ionSystem);
        this.ionSystem = ionSystem;
        this.isClosed.set(false);
    }

    public String getTransactionId() {
        return this.txnId;
    }

    QldbHash getTransactionHash() {
        return this.txnHash;
    }

    void setTransactionHash(QldbHash hash) {
        this.txnHash = hash;
    }

    static QldbHash dot(QldbHash seed, String statement, List<IonValue> parameters, IonSystem ionSystem) {
        QldbHash statementHash = QldbHash.toQldbHash(statement, ionSystem);
        for (IonValue param : parameters) {
            statementHash = statementHash.dot(QldbHash.toQldbHash(param, ionSystem));
        }
        return seed.dot(statementHash);
    }
}

