/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public abstract class PayloadStorageConfigurationBase {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadStorageConfigurationBase.class);
    private String s3BucketName;
    private int payloadSizeThreshold = 0;
    private boolean alwaysThroughS3 = false;
    private boolean payloadSupport = false;
    private ServerSideEncryptionStrategy serverSideEncryptionStrategy;
    private ObjectCannedACL objectCannedACL;

    public PayloadStorageConfigurationBase() {
        this.s3BucketName = null;
        this.serverSideEncryptionStrategy = null;
        this.objectCannedACL = null;
    }

    public PayloadStorageConfigurationBase(PayloadStorageConfigurationBase other) {
        this.s3BucketName = other.getS3BucketName();
        this.payloadSupport = other.isPayloadSupportEnabled();
        this.alwaysThroughS3 = other.isAlwaysThroughS3();
        this.payloadSizeThreshold = other.getPayloadSizeThreshold();
        this.serverSideEncryptionStrategy = other.getServerSideEncryptionStrategy();
        this.objectCannedACL = other.getObjectCannedACL();
    }

    protected void setPayloadSupportEnabled(String s3BucketName) {
        if (s3BucketName == null) {
            String errorMessage = "S3 bucket name cannot be null.";
            LOG.error(errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        if (this.isPayloadSupportEnabled()) {
            LOG.warn("Payload support is already enabled. Overwriting AmazonS3Client and S3BucketName.");
        }
        this.s3BucketName = s3BucketName;
        this.payloadSupport = true;
        LOG.info("Payload support enabled.");
    }

    public void setPayloadSupportDisabled() {
        this.s3BucketName = null;
        this.payloadSupport = false;
        LOG.info("Payload support disabled.");
    }

    public boolean isPayloadSupportEnabled() {
        return this.payloadSupport;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public int getPayloadSizeThreshold() {
        return this.payloadSizeThreshold;
    }

    public void setPayloadSizeThreshold(int payloadSizeThreshold) {
        this.payloadSizeThreshold = payloadSizeThreshold;
    }

    public boolean isAlwaysThroughS3() {
        return this.alwaysThroughS3;
    }

    public void setAlwaysThroughS3(boolean alwaysThroughS3) {
        this.alwaysThroughS3 = alwaysThroughS3;
    }

    public void setServerSideEncryptionStrategy(ServerSideEncryptionStrategy serverSideEncryptionStrategy) {
        this.serverSideEncryptionStrategy = serverSideEncryptionStrategy;
    }

    public ServerSideEncryptionStrategy getServerSideEncryptionStrategy() {
        return this.serverSideEncryptionStrategy;
    }

    public void setObjectCannedACL(ObjectCannedACL objectCannedACL) {
        this.objectCannedACL = objectCannedACL;
    }

    public boolean isObjectCannedACLDefined() {
        return null != this.objectCannedACL;
    }

    public ObjectCannedACL getObjectCannedACL() {
        return this.objectCannedACL;
    }
}

