/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.payloadoffloading.PayloadStorageConfigurationBase;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public class PayloadStorageConfiguration
extends PayloadStorageConfigurationBase {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadStorageConfiguration.class);
    private S3Client s3;

    public PayloadStorageConfiguration() {
        this.s3 = null;
    }

    public PayloadStorageConfiguration(PayloadStorageConfiguration other) {
        super(other);
        this.s3 = other.getS3Client();
    }

    public void setPayloadSupportEnabled(S3Client s3, String s3BucketName) {
        if (s3 == null || s3BucketName == null) {
            String errorMessage = "S3 client and/or S3 bucket name cannot be null.";
            LOG.error(errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        super.setPayloadSupportEnabled(s3BucketName);
        this.s3 = s3;
    }

    public PayloadStorageConfiguration withPayloadSupportEnabled(S3Client s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    @Override
    public void setPayloadSupportDisabled() {
        super.setPayloadSupportDisabled();
        this.s3 = null;
    }

    public PayloadStorageConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public S3Client getS3Client() {
        return this.s3;
    }

    public PayloadStorageConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public PayloadStorageConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public PayloadStorageConfiguration withServerSideEncryption(ServerSideEncryptionStrategy serverSideEncryptionStrategy) {
        this.setServerSideEncryptionStrategy(serverSideEncryptionStrategy);
        return this;
    }

    public PayloadStorageConfiguration withObjectCannedACL(ObjectCannedACL objectCannedACL) {
        this.setObjectCannedACL(objectCannedACL);
        return this;
    }
}

