/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.ConnectionPoolStats;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.RequestSigner;
import com.amazon.pay.api.ServiceConstants;
import com.amazon.pay.api.SignatureHelper;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.AmazonSignatureAlgorithm;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AmazonPayClient {
    protected final PayConfiguration payConfiguration;
    protected final RequestSigner requestSigner;
    protected final PoolingHttpClientConnectionManager connectionManager;

    public AmazonPayClient(PayConfiguration payConfiguration) throws AmazonPayClientException {
        this.payConfiguration = payConfiguration;
        this.requestSigner = new RequestSigner(payConfiguration);
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(payConfiguration.getClientConnections());
        this.connectionManager.setDefaultMaxPerRoute(payConfiguration.getClientConnections());
    }

    public AmazonPayResponse deliveryTracker(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI deliveryTrackerURI = Util.getServiceURI(this.payConfiguration, "v2/deliveryTrackers");
        return this.callAPI(deliveryTrackerURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse getAuthorizationToken(String mwsAuthToken, String merchantId, Map<String, String> header) throws AmazonPayClientException {
        URI authorizationTokenURI = Util.getServiceURI(this.payConfiguration, "v2/authorizationTokens");
        URI getAuthorizationTokenURI = authorizationTokenURI.resolve(authorizationTokenURI.getPath() + "/" + mwsAuthToken + "?merchantId=" + merchantId);
        HashMap<String, List<String>> queryParametersMap = new HashMap<String, List<String>>();
        ArrayList<String> auxList = new ArrayList<String>();
        auxList.add(merchantId);
        queryParametersMap.put("merchantId", auxList);
        return this.callAPI(getAuthorizationTokenURI, "GET", queryParametersMap, "", header);
    }

    public AmazonPayResponse deliveryTracker(JSONObject payload) throws AmazonPayClientException {
        return this.deliveryTracker(payload, null);
    }

    public String generateButtonSignature(JSONObject payload) throws AmazonPayClientException {
        return this.generateButtonSignature(payload.toString());
    }

    public String generateButtonSignature(String payload) throws AmazonPayClientException {
        String signature = null;
        SignatureHelper signatureHelper = new SignatureHelper(this.payConfiguration);
        AmazonSignatureAlgorithm algorithm = this.payConfiguration.getAlgorithm();
        try {
            String stringToSign = signatureHelper.createStringToSign(payload, algorithm.getName());
            signature = signatureHelper.generateSignature(stringToSign, this.payConfiguration.getPrivateKey(), algorithm);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return signature;
    }

    public AmazonPayResponse callAPI(URI uri, String httpMethodName, Map<String, List<String>> queryParameters, String request, Map<String, String> header) throws AmazonPayClientException {
        Map<String, String> postSignedHeaders = this.requestSigner.signRequest(uri, httpMethodName, queryParameters, request, header);
        return this.processRequest(uri, postSignedHeaders, request, httpMethodName);
    }

    private AmazonPayResponse processRequest(URI uri, Map<String, String> postSignedHeaders, String payload, String httpMethodName) throws AmazonPayClientException {
        List<String> response;
        String rawResponseObject = null;
        JSONObject jsonResponse = null;
        AmazonPayResponse responseObject = new AmazonPayResponse();
        responseObject.setUrl(uri);
        responseObject.setMethod(httpMethodName);
        responseObject.setRawRequest(payload);
        responseObject.setHeaders(postSignedHeaders);
        try {
            int retry;
            long millisBefore = System.currentTimeMillis();
            response = this.sendRequest(uri, postSignedHeaders, payload, httpMethodName);
            int statusCode = Integer.parseInt(response.get(0));
            for (retry = 0; ServiceConstants.serviceErrors.containsValue(statusCode) && retry < this.payConfiguration.getMaxRetries(); ++retry) {
                long waitTime = this.payConfiguration.getRetryStrategy().getWaitTime(retry, statusCode);
                Thread.sleep(waitTime);
                response = this.sendRequest(uri, postSignedHeaders, payload, httpMethodName);
                statusCode = Integer.parseInt(response.get(0));
            }
            responseObject.setRetries(retry);
            responseObject.setStatus(statusCode);
            responseObject.setDuration(System.currentTimeMillis() - millisBefore);
            if (response.get(1) != null) {
                rawResponseObject = response.get(1);
                if (!StringUtils.isEmpty((String)response.get(1))) {
                    jsonResponse = new JSONObject(response.get(1));
                }
            }
        }
        catch (InterruptedException | JSONException e) {
            throw new AmazonPayClientException(e.getMessage(), (Exception)e);
        }
        responseObject.setResponse(jsonResponse);
        responseObject.setRawResponse(rawResponseObject);
        responseObject.setRequestId(response.get(2));
        return responseObject;
    }

    private List<String> sendRequest(URI uri, Map<String, String> headers, String payload, String httpMethodName) throws AmazonPayClientException {
        int responseCode;
        String requestId;
        StringBuffer response;
        ArrayList<String> result;
        block30: {
            result = new ArrayList<String>();
            response = new StringBuffer();
            requestId = null;
            responseCode = 0;
            try (CloseableHttpClient client = Optional.ofNullable(this.payConfiguration.getProxySettings()).isPresent() ? this.getClosableHttpClientWithPoolAndProxy() : this.getClosableHttpClientWithConnectionPool();){
                HttpUriRequest httpUriRequest = Util.getHttpUriRequest(uri, httpMethodName, payload);
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpUriRequest.addHeader(entry.getKey(), entry.getValue());
                }
                CloseableHttpResponse responses = client.execute(httpUriRequest);
                responseCode = responses.getStatusLine().getStatusCode();
                if (responseCode < 400) {
                    requestId = responses.getFirstHeader("X-Amz-Pay-Request-Id").toString();
                    if (Optional.ofNullable(responses.getEntity()).isPresent()) {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(responses.getEntity().getContent(), "UTF-8"));){
                            String inputLine;
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine).append(System.lineSeparator());
                            }
                            break block30;
                        }
                    }
                    response.append("{}").append(System.lineSeparator());
                    break block30;
                }
                response.append(EntityUtils.toString((HttpEntity)responses.getEntity()));
            }
            catch (IOException exception) {
                throw new AmazonPayClientException(exception.getMessage(), exception);
            }
        }
        result.add(String.valueOf(responseCode));
        result.add(response.toString());
        result.add(requestId);
        return result;
    }

    public ConnectionPoolStats getPoolStats() {
        PoolStats poolStats = this.connectionManager.getTotalStats();
        ConnectionPoolStats connectionPoolStats = new ConnectionPoolStats(poolStats.getMax(), poolStats.getAvailable(), poolStats.getPending(), poolStats.getLeased());
        return connectionPoolStats;
    }

    protected CloseableHttpClient getClosableHttpClientWithConnectionPool() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setConnectionManagerShared(true);
        Util.applyRequestConfig(httpClientBuilder, this.payConfiguration);
        return httpClientBuilder.build();
    }

    protected CloseableHttpClient getClosableHttpClientWithPoolAndProxy() {
        return Util.getHttpClientBuilderWithProxy(this.payConfiguration.getProxySettings(), this.payConfiguration).setConnectionManager((HttpClientConnectionManager)this.connectionManager).setConnectionManagerShared(true).build();
    }

    public AmazonPayResponse registerAmazonPayAccount(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI registerAmazonPayAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        return this.callAPI(registerAmazonPayAccountURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse registerAmazonPayAccount(JSONObject payload) throws AmazonPayClientException {
        return this.registerAmazonPayAccount(payload, null);
    }

    public AmazonPayResponse updateAmazonPayAccount(String merchantAccountId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI updateAmazonPayAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        URI updateAmazonPayAccountFinalURI = updateAmazonPayAccountURI.resolve(updateAmazonPayAccountURI.getPath() + "/" + merchantAccountId);
        return this.callAPI(updateAmazonPayAccountFinalURI, "PATCH", null, payload.toString(), header);
    }

    public AmazonPayResponse updateAmazonPayAccount(String merchantAccountId, JSONObject payload) throws AmazonPayClientException {
        return this.updateAmazonPayAccount(merchantAccountId, payload, null);
    }

    public AmazonPayResponse deleteAmazonPayAccount(String merchantAccountId, Map<String, String> header) throws AmazonPayClientException {
        URI deleteAmazonPayAccountURI = Util.getServiceURI(this.payConfiguration, "v2/merchantAccounts");
        URI deleteAmazonPayAccountFinalURI = deleteAmazonPayAccountURI.resolve(deleteAmazonPayAccountURI.getPath() + "/" + merchantAccountId);
        return this.callAPI(deleteAmazonPayAccountFinalURI, "DELETE", null, "", header);
    }

    public AmazonPayResponse deleteAmazonPayAccount(String merchantAccountId) throws AmazonPayClientException {
        return this.deleteAmazonPayAccount(merchantAccountId, null);
    }
}

