/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayClient;
import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import java.net.URI;
import java.util.Map;
import net.sf.json.JSONObject;

public class WebstoreClient
extends AmazonPayClient {
    public WebstoreClient(PayConfiguration payConfiguration) throws AmazonPayClientException {
        super(payConfiguration);
    }

    public AmazonPayResponse createCheckoutSession(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createCheckoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createCheckoutSessionURI, "POST", this.queryParametersMap, payload.toString(), headerMap);
    }

    public AmazonPayResponse createCheckoutSession(JSONObject payload) throws AmazonPayClientException {
        return this.createCheckoutSession(payload, null);
    }

    public AmazonPayResponse getCheckoutSession(String checkoutSessionId, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI getCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId);
        return this.callAPI(getCheckoutSessionURI, "GET", this.queryParametersMap, "", header);
    }

    public AmazonPayResponse getCheckoutSession(String checkoutSessionId) throws AmazonPayClientException {
        return this.getCheckoutSession(checkoutSessionId, null);
    }

    public AmazonPayResponse updateCheckoutSession(String checkoutSessionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI updateCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId);
        return this.callAPI(updateCheckoutSessionURI, "PATCH", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse updateCheckoutSession(String checkoutSessionId, JSONObject payload) throws AmazonPayClientException {
        return this.updateCheckoutSession(checkoutSessionId, payload, null);
    }

    public AmazonPayResponse completeCheckoutSession(String checkoutSessionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI completeCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId + "/complete");
        return this.callAPI(completeCheckoutSessionURI, "POST", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse completeCheckoutSession(String checkoutSessionId, JSONObject payload) throws AmazonPayClientException {
        return this.completeCheckoutSession(checkoutSessionId, payload, null);
    }

    public AmazonPayResponse getChargePermission(String chargePermissionsId, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI getChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionsId);
        return this.callAPI(getChargePermissionURI, "GET", this.queryParametersMap, "", header);
    }

    public AmazonPayResponse getChargePermission(String chargePermissionsId) throws AmazonPayClientException {
        return this.getChargePermission(chargePermissionsId, null);
    }

    public AmazonPayResponse updateChargePermission(String chargePermissionsId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI updateChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionsId);
        return this.callAPI(updateChargePermissionURI, "PATCH", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse updateChargePermission(String chargePermissionsId, JSONObject payload) throws AmazonPayClientException {
        return this.updateChargePermission(chargePermissionsId, payload, null);
    }

    public AmazonPayResponse closeChargePermission(String chargePermissionsId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI closeChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionsId + "/close");
        return this.callAPI(closeChargePermissionURI, "DELETE", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse closeChargePermission(String chargePermissionsId, JSONObject payload) throws AmazonPayClientException {
        return this.closeChargePermission(chargePermissionsId, payload, null);
    }

    public AmazonPayResponse createCharge(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createChargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createChargesURI, "POST", this.queryParametersMap, payload.toString(), headerMap);
    }

    public AmazonPayResponse createCharge(JSONObject payload) throws AmazonPayClientException {
        return this.createCharge(payload, null);
    }

    public AmazonPayResponse getCharge(String chargeId, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI getChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId);
        return this.callAPI(getChargeURI, "GET", this.queryParametersMap, "", header);
    }

    public AmazonPayResponse getCharge(String chargeId) throws AmazonPayClientException {
        return this.getCharge(chargeId, null);
    }

    public AmazonPayResponse captureCharge(String chargeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI captureChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId + "/capture");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(captureChargeURI, "POST", this.queryParametersMap, payload.toString(), headerMap);
    }

    public AmazonPayResponse captureCharge(String chargeId, JSONObject payload) throws AmazonPayClientException {
        return this.captureCharge(chargeId, payload, null);
    }

    public AmazonPayResponse cancelCharge(String chargeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI cancelChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId + "/cancel");
        return this.callAPI(cancelChargeURI, "DELETE", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse cancelCharge(String chargeId, JSONObject payload) throws AmazonPayClientException {
        return this.cancelCharge(chargeId, payload, null);
    }

    public AmazonPayResponse createRefund(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createRefundsURI = Util.getServiceURI(this.payConfiguration, "v2/refunds");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createRefundsURI, "POST", this.queryParametersMap, payload.toString(), headerMap);
    }

    public AmazonPayResponse createRefund(JSONObject payload) throws AmazonPayClientException {
        return this.createRefund(payload, null);
    }

    public AmazonPayResponse getRefund(String refundId, Map<String, String> header) throws AmazonPayClientException {
        URI refundsURI = Util.getServiceURI(this.payConfiguration, "v2/refunds");
        URI getRefundURI = refundsURI.resolve(refundsURI.getPath() + "/" + refundId + "/");
        return this.callAPI(getRefundURI, "GET", this.queryParametersMap, "", header);
    }

    public AmazonPayResponse getRefund(String refundId) throws AmazonPayClientException {
        return this.getRefund(refundId, null);
    }
}

