/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.opentelemetry.awspropagator;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.aws.AwsXrayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class AwsCompositePropagator
implements TextMapPropagator {
    private static final List<TextMapPropagator> PROPAGATORS = Arrays.asList(W3CBaggagePropagator.getInstance(), AwsXrayPropagator.getInstance(), W3CTraceContextPropagator.getInstance(), B3Propagator.injectingMultiHeaders());
    private static final ContextKey<TextMapPropagator> EXTRACTED_PROPAGATOR = ContextKey.named((String)"extracted-propagator");
    private final List<String> fields;
    private final boolean injectExtractedFormat;

    public static AwsCompositePropagator injectingExtractedFormat() {
        return new AwsCompositePropagator(true);
    }

    public static AwsCompositePropagator injectingAwsFormat() {
        return new AwsCompositePropagator(false);
    }

    private AwsCompositePropagator(boolean injectExtractedFormat) {
        this.injectExtractedFormat = injectExtractedFormat;
        this.fields = PROPAGATORS.stream().flatMap(p -> p.fields().stream()).collect(Collectors.toList());
    }

    public Collection<String> fields() {
        return this.fields;
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        TextMapPropagator extractedPropagator;
        if (this.injectExtractedFormat && (extractedPropagator = (TextMapPropagator)context.get(EXTRACTED_PROPAGATOR)) != null) {
            extractedPropagator.inject(context, carrier, setter);
            Baggage baggage = Baggage.fromContextOrNull((Context)context);
            if (baggage != null && extractedPropagator != AwsXrayPropagator.getInstance()) {
                W3CBaggagePropagator.getInstance().inject(context, carrier, setter);
            }
            return;
        }
        AwsXrayPropagator.getInstance().inject(context, carrier, setter);
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        for (TextMapPropagator propagator : PROPAGATORS) {
            context = propagator.extract(context, carrier, getter);
            if (Span.fromContextOrNull((Context)context) == null) continue;
            if (this.injectExtractedFormat) {
                context = context.with(EXTRACTED_PROPAGATOR, (Object)propagator);
            }
            return context;
        }
        return context;
    }
}

