/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.SemanticAttributes;

public final class InternalServerAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;
    private final Mode oldSemconvMode;

    public InternalServerAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes, Mode oldSemconvMode) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
        this.oldSemconvMode = oldSemconvMode;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort serverAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (serverAddressAndPort.address != null) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.SERVER_ADDRESS, serverAddressAndPort.address);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, this.oldSemconvMode.address, serverAddressAndPort.address);
            }
            if (serverAddressAndPort.port != null && serverAddressAndPort.port > 0) {
                if (this.emitStableUrlAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.SERVER_PORT, Long.valueOf(serverAddressAndPort.port.intValue()));
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet(attributes, this.oldSemconvMode.port, Long.valueOf(serverAddressAndPort.port.intValue()));
                }
            }
        }
    }

    public static enum Mode {
        PEER(SemanticAttributes.NET_PEER_NAME, SemanticAttributes.NET_PEER_PORT),
        HOST(SemanticAttributes.NET_HOST_NAME, SemanticAttributes.NET_HOST_PORT);

        final AttributeKey<String> address;
        final AttributeKey<Long> port;

        private Mode(AttributeKey<String> address, AttributeKey<Long> port) {
            this.address = address;
            this.port = port;
        }
    }
}

