/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.context;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import java.util.logging.Level;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final PatchLogger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return () -> {
            if (this.current() != toAttach) {
                logger.log(Level.FINE, "Context in storage not the expected context, Scope.close was not called correctly");
            }
            THREAD_LOCAL_STORAGE.set(beforeAttach);
        };
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static {
        logger = PatchLogger.getLogger(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }
}

