/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.EndTimeExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.StartTimeExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ClientSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ServerSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> extractors;
    private final List<? extends RequestListener> requestListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final StartTimeExtractor<REQUEST> startTimeExtractor;
    private final EndTimeExtractor<RESPONSE> endTimeExtractor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> newBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.openTelemetry.getTracer(this.instrumentationName, InstrumentationVersion.VERSION);
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.extractors = new ArrayList(builder.attributesExtractors);
        this.requestListeners = new ArrayList<RequestListener>(builder.requestListeners);
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.startTimeExtractor = builder.startTimeExtractor;
        this.endTimeExtractor = builder.endTimeExtractor;
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        boolean suppressed = false;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        switch (spanKind) {
            case SERVER: {
                suppressed = ServerSpan.fromContextOrNull(parentContext) != null;
                break;
            }
            case CLIENT: {
                suppressed = ClientSpan.fromContextOrNull(parentContext) != null;
                break;
            }
        }
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    public Context start(Context parentContext, REQUEST request) {
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        if (this.startTimeExtractor != null) {
            spanBuilder.setStartTimestamp(this.startTimeExtractor.extract(request));
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.extractors) {
            extractor.onStart(attributesBuilder, request);
        }
        Attributes attributes = attributesBuilder.build();
        Context context = parentContext;
        for (RequestListener requestListener : this.requestListeners) {
            context = requestListener.start(context, attributes);
        }
        attributes.forEach((key, value) -> spanBuilder.setAttribute(key, value));
        Span span = spanBuilder.startSpan();
        context = context.with(span);
        switch (spanKind) {
            case SERVER: {
                return ServerSpan.with(context, span);
            }
            case CLIENT: {
                return ClientSpan.with(context, span);
            }
        }
        return context;
    }

    public void end(Context context, REQUEST request, RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCode;
        Span span = Span.fromContext(context);
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.extractors) {
            attributesExtractor.onEnd(attributesBuilder, request, response);
        }
        Attributes attributes = attributesBuilder.build();
        for (RequestListener requestListener : this.requestListeners) {
            requestListener.end(context, attributes);
        }
        attributes.forEach((key, value) -> span.setAttribute(key, value));
        if (error != null) {
            error = this.errorCauseExtractor.extractCause(error);
            span.recordException(error);
        }
        if ((statusCode = this.spanStatusExtractor.extract(request, response, error)) != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
        if (this.endTimeExtractor != null) {
            span.end(this.endTimeExtractor.extract(response));
        } else {
            span.end();
        }
    }
}

