/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.PropagatingFromUpstreamInstrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.PropagatingToDownstreamInstrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    private static final SpanSuppressionStrategy spanSuppressionStrategy = SpanSuppressionStrategy.fromConfig(ConfigPropertiesUtil.getString("otel.instrumentation.experimental.span-suppression-strategy"));
    final OpenTelemetry openTelemetry;
    final String instrumentationName;
    final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    final List<SpanLinksExtractor<? super REQUEST>> spanLinksExtractors = new ArrayList<SpanLinksExtractor<? super REQUEST>>();
    final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    final List<ContextCustomizer<? super REQUEST>> contextCustomizers = new ArrayList<ContextCustomizer<? super REQUEST>>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private final List<OperationMetrics> operationMetrics = new ArrayList<OperationMetrics>();
    @Nullable
    private String instrumentationVersion;
    @Nullable
    private String schemaUrl = null;
    SpanKindExtractor<? super REQUEST> spanKindExtractor = SpanKindExtractor.alwaysInternal();
    SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.getDefault();
    boolean enabled = true;

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.spanNameExtractor = spanNameExtractor;
        this.instrumentationVersion = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setInstrumentationVersion(String instrumentationVersion) {
        this.instrumentationVersion = Objects.requireNonNull(instrumentationVersion, "instrumentationVersion");
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSchemaUrl(String schemaUrl) {
        this.schemaUrl = Objects.requireNonNull(schemaUrl, "schemaUrl");
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = Objects.requireNonNull(spanStatusExtractor, "spanStatusExtractor");
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(Objects.requireNonNull(attributesExtractor, "attributesExtractor"));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this::addAttributesExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addSpanLinksExtractor(SpanLinksExtractor<REQUEST> spanLinksExtractor) {
        this.spanLinksExtractors.add(Objects.requireNonNull(spanLinksExtractor, "spanLinksExtractor"));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addContextCustomizer(ContextCustomizer<? super REQUEST> contextCustomizer) {
        this.contextCustomizers.add(Objects.requireNonNull(contextCustomizer, "contextCustomizer"));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addOperationListener(OperationListener listener) {
        this.operationListeners.add(Objects.requireNonNull(listener, "operationListener"));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addOperationMetrics(OperationMetrics factory) {
        this.operationMetrics.add(Objects.requireNonNull(factory, "operationMetrics"));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = Objects.requireNonNull(errorCauseExtractor, "errorCauseExtractor");
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> buildClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingToDownstream(Objects.requireNonNull(setter, "setter")), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> buildServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingFromUpstream(Objects.requireNonNull(getter, "getter")), SpanKindExtractor.alwaysServer());
    }

    public Instrumenter<REQUEST, RESPONSE> buildProducerInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingToDownstream(Objects.requireNonNull(setter, "setter")), SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<REQUEST, RESPONSE> buildConsumerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.buildInstrumenter(InstrumenterConstructor.propagatingFromUpstream(Objects.requireNonNull(getter, "getter")), SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<REQUEST, RESPONSE> buildInstrumenter() {
        return this.buildInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> buildInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.buildInstrumenter(InstrumenterConstructor.internal(), Objects.requireNonNull(spanKindExtractor, "spanKindExtractor"));
    }

    private Instrumenter<REQUEST, RESPONSE> buildInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        this.spanKindExtractor = spanKindExtractor;
        return constructor.create(this);
    }

    Tracer buildTracer() {
        TracerBuilder tracerBuilder = this.openTelemetry.getTracerProvider().tracerBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            tracerBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if (this.schemaUrl != null) {
            tracerBuilder.setSchemaUrl(this.schemaUrl);
        }
        return tracerBuilder.build();
    }

    List<OperationListener> buildOperationListeners() {
        if (this.operationMetrics.isEmpty()) {
            return new ArrayList<OperationListener>(this.operationListeners);
        }
        ArrayList<OperationListener> listeners = new ArrayList<OperationListener>(this.operationListeners.size() + this.operationMetrics.size());
        listeners.addAll(this.operationListeners);
        MeterBuilder meterBuilder = this.openTelemetry.getMeterProvider().meterBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            meterBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if (this.schemaUrl != null) {
            meterBuilder.setSchemaUrl(this.schemaUrl);
        }
        Meter meter = meterBuilder.build();
        for (OperationMetrics factory : this.operationMetrics) {
            listeners.add(factory.create(meter));
        }
        return listeners;
    }

    SpanSuppressor buildSpanSuppressor() {
        return spanSuppressionStrategy.create(this.getSpanKeysFromAttributesExtractors());
    }

    private Set<SpanKey> getSpanKeysFromAttributesExtractors() {
        return this.attributesExtractors.stream().filter(SpanKeyProvider.class::isInstance).map(SpanKeyProvider.class::cast).flatMap(provider -> {
            SpanKey spanKey = provider.internalGetSpanKey();
            return spanKey == null ? Stream.of(new SpanKey[0]) : Stream.of(spanKey);
        }).collect(Collectors.toSet());
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(InstrumenterBuilder<RQ, RS> var1);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(TextMapSetter<RQ> setter) {
            return builder -> new PropagatingToDownstreamInstrumenter(builder, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(TextMapGetter<RQ> getter) {
            return builder -> new PropagatingFromUpstreamInstrumenter(builder, getter);
        }
    }
}

