/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Map;
import java.util.Set;

interface SpanSuppressor {
    public Context storeInContext(Context var1, SpanKind var2, Span var3);

    public boolean shouldSuppress(Context var1, SpanKind var2);

    public static final class BySpanKey
    implements SpanSuppressor {
        private final Set<SpanKey> spanKeys;

        BySpanKey(Set<SpanKey> spanKeys) {
            this.spanKeys = spanKeys;
        }

        @Override
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            for (SpanKey spanKey : this.spanKeys) {
                context = spanKey.storeInContext(context, span);
            }
            return context;
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            for (SpanKey spanKey : this.spanKeys) {
                if (spanKey.fromContextOrNull(parentContext) != null) continue;
                return false;
            }
            return true;
        }
    }

    public static final class DelegateBySpanKind
    implements SpanSuppressor {
        private final Map<SpanKind, SpanSuppressor> delegates;

        DelegateBySpanKind(Map<SpanKind, SpanSuppressor> delegates) {
            this.delegates = delegates;
        }

        @Override
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            SpanSuppressor delegate = this.delegates.get((Object)spanKind);
            if (delegate == null) {
                return context;
            }
            return delegate.storeInContext(context, spanKind, span);
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            SpanSuppressor delegate = this.delegates.get((Object)spanKind);
            if (delegate == null) {
                return false;
            }
            return delegate.shouldSuppress(parentContext, spanKind);
        }
    }

    public static enum Noop implements SpanSuppressor
    {
        INSTANCE;


        @Override
        public Context storeInContext(Context context, SpanKind spanKind, Span span) {
            return context;
        }

        @Override
        public boolean shouldSuppress(Context parentContext, SpanKind spanKind) {
            return false;
        }
    }
}

