/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.regex.Pattern;

public final class ValidationUtil {
    public static final String API_USAGE_LOGGER_NAME = "io.opentelemetry.ApiUsageLogging";
    private static final PatchLogger API_USAGE_LOGGER = PatchLogger.getLogger("io.opentelemetry.ApiUsageLogging");
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z]){1}([A-Za-z0-9\\_\\-\\.]){0,62}");

    public static void log(String message) {
        ValidationUtil.log(message, Level.FINEST);
    }

    public static void log(String message, Level level) {
        API_USAGE_LOGGER.log(level, message, (Throwable)((Object)new AssertionError()));
    }

    public static boolean checkValidInstrumentName(String name) {
        return ValidationUtil.checkValidInstrumentName(name, "");
    }

    public static boolean checkValidInstrumentName(String name, String logSuffix) {
        if (name != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(name).matches()) {
            return true;
        }
        ValidationUtil.log("Instrument name \"" + name + "\" is invalid, returning noop instrument. Instrument names must consist of 63 or less characters including alphanumeric, _, ., -, and start with a letter." + logSuffix, Level.WARNING);
        return false;
    }

    public static boolean checkValidInstrumentUnit(String unit) {
        return ValidationUtil.checkValidInstrumentUnit(unit, "");
    }

    public static boolean checkValidInstrumentUnit(String unit, String logSuffix) {
        if (unit != null && !unit.equals("") && unit.length() < 64 && StandardCharsets.US_ASCII.newEncoder().canEncode(unit)) {
            return true;
        }
        ValidationUtil.log("Unit \"" + unit + "\" is invalid. Instrument unit must be 63 or less ASCII characters." + logSuffix, Level.WARNING);
        return false;
    }

    private ValidationUtil() {
    }
}

