/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class AgentInitializer {
    private static ClassLoader AGENT_CLASSLOADER = null;

    public static void initialize(Instrumentation inst, URL bootstrapUrl) throws Exception {
        AgentInitializer.startAgent(inst, bootstrapUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startAgent(Instrumentation inst, URL bootstrapUrl) throws Exception {
        if (AGENT_CLASSLOADER == null) {
            ClassLoader agentClassLoader = AgentInitializer.createAgentClassLoader("inst", bootstrapUrl);
            Class<?> agentInstallerClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
            Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
            ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
                agentInstallerMethod.invoke(null, inst);
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedContextClassLoader);
            }
            AGENT_CLASSLOADER = agentClassLoader;
        }
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, URL bootstrapUrl) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapUrl, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    public static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }
}

