/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import java.util.Arrays;

public interface AttributesBuilder {
    public Attributes build();

    public <T> AttributesBuilder put(AttributeKey<Long> var1, int var2);

    public <T> AttributesBuilder put(AttributeKey<T> var1, T var2);

    default public AttributesBuilder put(String key, String value) {
        return this.put(AttributeKey.stringKey(key), value);
    }

    default public AttributesBuilder put(String key, long value) {
        return this.put(AttributeKey.longKey(key), Long.valueOf(value));
    }

    default public AttributesBuilder put(String key, double value) {
        return this.put(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    default public AttributesBuilder put(String key, boolean value) {
        return this.put(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    default public AttributesBuilder put(String key, String ... value) {
        return this.put(AttributeKey.stringArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    default public AttributesBuilder put(String key, long ... value) {
        return this.put(AttributeKey.longArrayKey(key), ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, double ... value) {
        return this.put(AttributeKey.doubleArrayKey(key), ArrayBackedAttributesBuilder.toList(value));
    }

    default public AttributesBuilder put(String key, boolean ... value) {
        return this.put(AttributeKey.booleanArrayKey(key), ArrayBackedAttributesBuilder.toList(value));
    }

    public AttributesBuilder putAll(Attributes var1);
}

