/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.db;

import io.opentelemetry.javaagent.instrumentation.api.BoundedCache;
import io.opentelemetry.javaagent.instrumentation.api.db.AutoSqlSanitizer;
import io.opentelemetry.javaagent.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.instrumentation.api.db.StatementSanitizationConfig;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;

public final class SqlStatementSanitizer {
    private static final Logger log = LoggerFactory.getLogger(SqlStatementSanitizer.class);
    private static final BoundedCache<String, SqlStatementInfo> sqlToStatementInfoCache = BoundedCache.build(1000L);

    public static SqlStatementInfo sanitize(String statement) {
        if (!StatementSanitizationConfig.isStatementSanitizationEnabled() || statement == null) {
            return new SqlStatementInfo(statement, null, null);
        }
        return sqlToStatementInfoCache.get(statement, k -> {
            log.trace("SQL statement cache miss");
            return AutoSqlSanitizer.sanitize(statement);
        });
    }

    private SqlStatementSanitizer() {
    }
}

