/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public interface BoundedCache<K, V> {
    public V get(K var1, Function<? super K, ? extends V> var2);

    public static <K, V> BoundedCache<K, V> build(long maxSize) {
        return Provider.get().build(maxSize);
    }

    public static class Provider {
        private static final Builder NEVER_ACTUALLY_CACHES = new Builder(){

            @Override
            public <K, V> BoundedCache<K, V> build(long maxSize) {
                return (key, mappingFunction) -> mappingFunction.apply(key);
            }
        };
        private static final AtomicReference<Builder> builderRef = new AtomicReference<Builder>(NEVER_ACTUALLY_CACHES);

        private Provider() {
        }

        public static boolean registerIfAbsent(Builder builder) {
            return builderRef.compareAndSet(NEVER_ACTUALLY_CACHES, builder);
        }

        static void reset() {
            builderRef.set(NEVER_ACTUALLY_CACHES);
        }

        public static Builder get() {
            return builderRef.get();
        }
    }

    public static interface Builder {
        public <K, V> BoundedCache<K, V> build(long var1);
    }
}

