/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.BigendianEncoding;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    private static final int SIZE = 8;
    private static final int HEX_SIZE = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getSize() {
        return 8;
    }

    public static int getHexLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static String fromLong(long id) {
        char[] result = SpanId.getTemporaryBuffer();
        BigendianEncoding.longToBase16String(id, result, 0);
        return new String(result);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[16];
            charBuffer.set(chars);
        }
        return chars;
    }

    public static byte[] bytesFromHex(String src, int srcOffset) {
        return BigendianEncoding.bytesFromBase16(src, srcOffset, 16);
    }

    public static boolean isValid(String spanId) {
        return spanId.length() == 16 && !INVALID.equals(spanId) && BigendianEncoding.isValidBase16String(spanId);
    }

    public static String bytesToHex(byte[] spanId) {
        return BigendianEncoding.toLowerBase16(spanId);
    }

    public static long asLong(CharSequence src) {
        return BigendianEncoding.longFromBase16String(src, 0);
    }
}

