/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class AgentInitializer {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[opentelemetry.auto.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel";
    private static final String SIMPLE_LOGGER_PREFIX = "io.opentelemetry.javaagent.slf4j.simpleLogger.log.";
    private static final Logger log;
    private static ClassLoader AGENT_CLASSLOADER;

    public static void initialize(Instrumentation inst, URL bootstrapUrl) {
        AgentInitializer.startAgent(inst, bootstrapUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startAgent(Instrumentation inst, URL bootstrapUrl) {
        if (AGENT_CLASSLOADER == null) {
            try {
                ClassLoader agentClassLoader = AgentInitializer.createAgentClassLoader("inst", bootstrapUrl);
                Class<?> agentInstallerClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(AGENT_CLASSLOADER);
                    agentInstallerMethod.invoke(null, inst);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedContextClassLoader);
                }
                AGENT_CLASSLOADER = agentClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the agent", ex);
            }
        }
    }

    private static void configureLogger() {
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (AgentInitializer.isDebugMode()) {
            AgentInitializer.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
            AgentInitializer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.perfmark.PerfMark", "INFO");
            AgentInitializer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.Context", "INFO");
            AgentInitializer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.internal.ServerImplBuilder", "INFO");
            AgentInitializer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.io.grpc.internal.ManagedChannelImplBuilder", "INFO");
        } else {
            AgentInitializer.setSystemPropertyDefault("io.opentelemetry.javaagent.slf4j.simpleLogger.log.muzzleMatcher", "OFF");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, URL bootstrapUrl) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapUrl, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "otel.javaagent.debug";
        String tracerDebugLevelProp = System.getProperty(tracerDebugLevelSysprop);
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(tracerDebugLevelSysprop.replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    public static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    static {
        AgentInitializer.configureLogger();
        log = LoggerFactory.getLogger(AgentInitializer.class);
        AGENT_CLASSLOADER = null;
    }
}

