/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collection;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.EndpointConnectionMetrics;

public class ConnectionMetricsCollector {
    private final Map<String, EndpointConnectionMetrics> connectionMetrics;

    public ConnectionMetricsCollector(Map<String, EndpointConnectionMetrics> connectionMetrics) {
        this.connectionMetrics = connectionMetrics;
    }

    public Collection<EndpointConnectionMetrics> metrics() {
        return this.connectionMetrics.values();
    }

    public long totalConnectionAttempts() {
        long totalConnectionAttempts = 0L;
        for (EndpointConnectionMetrics cm : this.connectionMetrics.values()) {
            totalConnectionAttempts += cm.getTotalAttempts();
        }
        return totalConnectionAttempts;
    }

    void succeeded(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).succeeded(startMillis);
        }
    }

    void unavailable(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).unavailable(startMillis);
        }
    }

    void closing(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).closing(startMillis);
        }
    }

    void dead(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).dead(startMillis);
        }
    }

    void npe(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).npe(startMillis);
        }
    }

    void nha(String address, long startMillis) {
        if (this.connectionMetrics.containsKey(address)) {
            this.connectionMetrics.get(address).nha(startMillis);
        }
    }
}

