/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.AcquireConnectionConfig;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.ClientClusterCollection;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ClusterFactory;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.ConnectionAttemptManager;
import org.apache.tinkerpop.gremlin.driver.EagerRefreshContext;
import org.apache.tinkerpop.gremlin.driver.EmptyEndpointFilter;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointClient;
import org.apache.tinkerpop.gremlin.driver.EndpointClientCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointStrategies;
import org.apache.tinkerpop.gremlin.driver.EndpointsUnavailableException;
import org.apache.tinkerpop.gremlin.driver.Refreshable;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.utils.CollectionUtils;

public class GremlinClient
extends Client
implements Refreshable,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinClient.class);
    private final AtomicReference<EndpointClientCollection> endpointClientCollection = new AtomicReference<EndpointClientCollection>(new EndpointClientCollection());
    private final AtomicLong index = new AtomicLong(0L);
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private final ConnectionAttemptManager connectionAttemptManager;
    private final ClientClusterCollection clientClusterCollection;
    private final ClusterFactory clusterFactory;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final EndpointStrategies endpointStrategies;
    private final AcquireConnectionConfig acquireConnectionConfig;

    GremlinClient(Cluster cluster, Client.Settings settings, EndpointClientCollection endpointClientCollection, ClientClusterCollection clientClusterCollection, ClusterFactory clusterFactory, EndpointStrategies endpointStrategies, AcquireConnectionConfig acquireConnectionConfig) {
        super(cluster, settings);
        this.endpointClientCollection.set(endpointClientCollection);
        this.clientClusterCollection = clientClusterCollection;
        this.clusterFactory = clusterFactory;
        this.endpointStrategies = endpointStrategies;
        this.acquireConnectionConfig = acquireConnectionConfig;
        this.connectionAttemptManager = acquireConnectionConfig.createConnectionAttemptManager(this);
        logger.info("availableEndpointFilter: {}", (Object)endpointStrategies.endpointFilter());
    }

    @Override
    public synchronized void refreshEndpoints(EndpointCollection endpoints) {
        if (this.closing.get() != null) {
            return;
        }
        EmptyEndpointFilter endpointFilter = new EmptyEndpointFilter(this.endpointStrategies.endpointFilter());
        EndpointClientCollection currentEndpointClientCollection = this.endpointClientCollection.get();
        EndpointCollection enrichedEndpoints = endpoints.getEnrichedEndpoints(endpointFilter);
        EndpointCollection acceptedEndpoints = enrichedEndpoints.getAcceptedEndpoints(endpointFilter);
        EndpointCollection rejectedEndpoints = enrichedEndpoints.getRejectedEndpoints(endpointFilter);
        List<EndpointClient> survivingEndpointClients = currentEndpointClientCollection.getSurvivingEndpointClients(acceptedEndpoints);
        EndpointCollection newEndpoints = acceptedEndpoints.getEndpointsWithNoCluster(this.clientClusterCollection);
        Map<Endpoint, Cluster> newEndpointClusters = this.clientClusterCollection.createClustersForEndpoints(newEndpoints);
        List<EndpointClient> newEndpointClients = EndpointClient.create(newEndpointClusters);
        EndpointClientCollection newEndpointClientCollection = new EndpointClientCollection(CollectionUtils.join(survivingEndpointClients, newEndpointClients), rejectedEndpoints);
        this.endpointClientCollection.set(newEndpointClientCollection);
        this.clientClusterCollection.removeClustersWithNoMatchingEndpoint(newEndpointClientCollection.endpoints());
    }

    protected void initializeImplementation() {
    }

    protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
        long start = System.currentTimeMillis();
        logger.debug("Choosing connection");
        Connection connection = null;
        while (connection == null) {
            EndpointClientCollection currentEndpointClientCollection = this.endpointClientCollection.get();
            while (currentEndpointClientCollection.isEmpty()) {
                if (this.connectionAttemptManager.maxWaitTimeExceeded(start)) {
                    if (currentEndpointClientCollection.hasRejectedEndpoints()) {
                        throw new EndpointsUnavailableException(currentEndpointClientCollection.rejectionReasons());
                    }
                    throw new TimeoutException("Timed-out waiting for connection");
                }
                if (this.connectionAttemptManager.eagerRefreshWaitTimeExceeded(start)) {
                    this.connectionAttemptManager.triggerEagerRefresh(new EagerRefreshContext());
                }
                try {
                    Thread.sleep(this.acquireConnectionConfig.acquireConnectionBackoffMillis());
                    currentEndpointClientCollection = this.endpointClientCollection.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            connection = currentEndpointClientCollection.chooseConnection(msg, ec -> ec.get((int)(this.index.getAndIncrement() % (long)ec.size())));
            if (connection != null) continue;
            if (this.connectionAttemptManager.maxWaitTimeExceeded(start)) {
                throw new TimeoutException("Timed-out waiting for connection");
            }
            if (this.connectionAttemptManager.eagerRefreshWaitTimeExceeded(start)) {
                this.connectionAttemptManager.triggerEagerRefresh(new EagerRefreshContext());
            }
            try {
                Thread.sleep(this.acquireConnectionConfig.acquireConnectionBackoffMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        logger.debug("Connection: {} [{} ms]", (Object)connection.getConnectionInfo(), (Object)(System.currentTimeMillis() - start));
        return connection;
    }

    public Client alias(String graphOrTraversalSource) {
        return this.alias(this.makeDefaultAliasMap(graphOrTraversalSource));
    }

    public Client alias(Map<String, String> aliases) {
        return new GremlinAliasClusterClient(this, aliases, this.settings, this.clientClusterCollection);
    }

    public boolean isClosing() {
        return this.closing.get() != null;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        this.connectionAttemptManager.shutdownNow();
        this.executorService.shutdownNow();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (EndpointClient endpointClient : this.endpointClientCollection.get()) {
            futures.add(endpointClient.closeClientAsync());
        }
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    public synchronized Client init() {
        if (this.initialized) {
            return this;
        }
        logger.debug("Initializing internal clients");
        for (EndpointClient endpointClient : this.endpointClientCollection.get()) {
            endpointClient.initClient();
        }
        this.initializeImplementation();
        this.initialized = true;
        return this;
    }

    public String toString() {
        return "Client holder queue: " + System.lineSeparator() + this.endpointClientCollection.get().stream().map(c -> String.format("  {address: %s, isAvailable: %s}", c.endpoint().getAddress(), !c.client().getCluster().availableHosts().isEmpty())).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "Cluster collection: " + System.lineSeparator() + this.clientClusterCollection.toString();
    }

    public static class GremlinAliasClusterClient
    extends Client.AliasClusteredClient {
        private final ClientClusterCollection clientClusterCollection;

        GremlinAliasClusterClient(Client client, Map<String, String> aliases, Client.Settings settings, ClientClusterCollection clientClusterCollection) {
            super(client, aliases, settings);
            this.clientClusterCollection = clientClusterCollection;
        }

        public Cluster getCluster() {
            Cluster cluster = this.clientClusterCollection.getFirstOrNull();
            if (cluster != null) {
                logger.trace("Returning: Cluster: {}, Hosts: [{}}", (Object)cluster, (Object)cluster.availableHosts().stream().map(URI::toString).collect(Collectors.joining(", ")));
                return cluster;
            }
            logger.warn("Unable to find cluster with available hosts in cluster collection, so returning parent cluster, which has no hosts.");
            return super.getCluster();
        }
    }
}

