/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ClusterFactory;
import org.apache.tinkerpop.gremlin.driver.DatabaseEndpoint;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientClusterCollection {
    private final ClusterFactory clusterFactory;
    private final Cluster parentCluster;
    private final Map<String, Cluster> clusters = new ConcurrentHashMap<String, Cluster>();
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private static final Logger logger = LoggerFactory.getLogger(ClientClusterCollection.class);

    ClientClusterCollection(ClusterFactory clusterFactory, Cluster parentCluster) {
        this.clusterFactory = clusterFactory;
        this.parentCluster = parentCluster;
    }

    public Cluster createClusterForEndpoint(Endpoint endpoint) {
        Cluster cluster = this.clusterFactory.createCluster(Collections.singletonList(endpoint.getAddress()));
        this.clusters.put(endpoint.getAddress(), cluster);
        return cluster;
    }

    public Map<Endpoint, Cluster> createClustersForEndpoints(EndpointCollection endpoints) {
        HashMap<Endpoint, Cluster> results = new HashMap<Endpoint, Cluster>();
        for (Endpoint endpoint : endpoints) {
            results.put(endpoint, this.createClusterForEndpoint(endpoint));
        }
        return results;
    }

    public boolean containsClusterForEndpoint(Endpoint endpoint) {
        return this.clusters.containsKey(endpoint.getAddress());
    }

    public void removeClustersWithNoMatchingEndpoint(EndpointCollection endpoints) {
        this.removeClustersWithNoMatchingEndpoint(endpoints, cluster -> {
            if (cluster != null) {
                cluster.close();
            }
            return null;
        });
    }

    void removeClustersWithNoMatchingEndpoint(EndpointCollection endpoints, Function<Cluster, Void> clusterCloseMethod) {
        ArrayList<String> removalList = new ArrayList<String>();
        for (String address : this.clusters.keySet()) {
            if (endpoints.containsEndpoint(new DatabaseEndpoint().withAddress(address))) continue;
            removalList.add(address);
        }
        for (String address : removalList) {
            logger.info("Removing client for {}", (Object)address);
            Cluster cluster = this.clusters.remove(address);
            clusterCloseMethod.apply(cluster);
        }
    }

    public Cluster getParentCluster() {
        return this.parentCluster;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Cluster cluster : this.clusters.values()) {
            futures.add(cluster.closeAsync());
        }
        futures.add(this.parentCluster.closeAsync());
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    public Cluster getFirstOrNull() {
        Optional first = this.clusters.entrySet().stream().findFirst();
        return first.map(Map.Entry::getValue).orElse(null);
    }

    public String toString() {
        return this.clusters.entrySet().stream().map(e -> String.format("  {%s, %s, isClosed: %s}", e.getKey(), ((Cluster)e.getValue()).allHosts().stream().map(h -> h.getHostUri().toString()).collect(Collectors.joining(",")), ((Cluster)e.getValue()).isClosed())).collect(Collectors.joining(System.lineSeparator()));
    }
}

