/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.GremlinCluster;
import org.apache.tinkerpop.gremlin.driver.HandshakeInterceptor;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;

public class GremlinClusterBuilder {
    private List<String> addresses = new ArrayList<String>();
    private int port = 8182;
    private String path = "/gremlin";
    private MessageSerializer serializer = Serializers.GRAPHBINARY_V1D0.simpleInstance();
    private int nioPoolSize = Runtime.getRuntime().availableProcessors();
    private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private int minConnectionPoolSize = 2;
    private int maxConnectionPoolSize = 8;
    private int minSimultaneousUsagePerConnection = 8;
    private int maxSimultaneousUsagePerConnection = 16;
    private int maxInProcessPerConnection = 4;
    private int minInProcessPerConnection = 1;
    private int maxWaitForConnection = 16000;
    private int maxWaitForClose = 3000;
    private int maxContentLength = 65536;
    private int reconnectInterval = 1000;
    private int resultIterationBatchSize = 64;
    private long keepAliveInterval = 180000L;
    private String channelizer = Channelizer.WebSocketChannelizer.class.getName();
    private boolean enableSsl = false;
    private String trustCertChainFile = null;
    private String keyCertChainFile = null;
    private String keyFile = null;
    private String keyPassword = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;
    private String keyStoreType = null;
    private String validationRequest = "''";
    private List<String> sslEnabledProtocols = new ArrayList<String>();
    private List<String> sslCipherSuites = new ArrayList<String>();
    private boolean sslSkipCertValidation = false;
    private SslContext sslContext = null;
    private Supplier<LoadBalancingStrategy> loadBalancingStrategy = LoadBalancingStrategy.RoundRobin::new;
    private AuthProperties authProps = new AuthProperties();
    private int refreshOnErrorThreshold = -1;
    private Supplier<Collection<String>> refreshOnErrorEventHandler = null;
    private HandshakeInterceptor interceptor = HandshakeInterceptor.NO_OP;

    public static GremlinClusterBuilder build() {
        return new GremlinClusterBuilder();
    }

    private GremlinClusterBuilder() {
    }

    public GremlinClusterBuilder refreshOnErrorThreshold(int refreshOnErrorThreshold) {
        this.refreshOnErrorThreshold = refreshOnErrorThreshold;
        return this;
    }

    public GremlinClusterBuilder refreshOnErrorEventHandler(Supplier<Collection<String>> refreshOnErrorEventHandler) {
        this.refreshOnErrorEventHandler = refreshOnErrorEventHandler;
        return this;
    }

    public GremlinClusterBuilder nioPoolSize(int nioPoolSize) {
        this.nioPoolSize = nioPoolSize;
        return this;
    }

    public GremlinClusterBuilder workerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public GremlinClusterBuilder path(String path) {
        this.path = path;
        return this;
    }

    public GremlinClusterBuilder serializer(String mimeType) {
        this.serializer = Serializers.valueOf((String)mimeType).simpleInstance();
        return this;
    }

    public GremlinClusterBuilder serializer(Serializers mimeType) {
        this.serializer = mimeType.simpleInstance();
        return this;
    }

    public GremlinClusterBuilder serializer(MessageSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public GremlinClusterBuilder enableSsl(boolean enable) {
        this.enableSsl = enable;
        return this;
    }

    public GremlinClusterBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Deprecated
    public GremlinClusterBuilder trustCertificateChainFile(String certificateChainFile) {
        this.trustCertChainFile = certificateChainFile;
        return this;
    }

    public GremlinClusterBuilder keepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    @Deprecated
    public GremlinClusterBuilder keyCertChainFile(String keyCertChainFile) {
        this.keyCertChainFile = keyCertChainFile;
        return this;
    }

    @Deprecated
    public GremlinClusterBuilder keyFile(String keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    @Deprecated
    public GremlinClusterBuilder keyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public GremlinClusterBuilder keyStore(String keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public GremlinClusterBuilder keyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public GremlinClusterBuilder trustStore(String trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public GremlinClusterBuilder trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public GremlinClusterBuilder keyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public GremlinClusterBuilder sslEnabledProtocols(List<String> sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
        return this;
    }

    public GremlinClusterBuilder sslCipherSuites(List<String> sslCipherSuites) {
        this.sslCipherSuites = sslCipherSuites;
        return this;
    }

    public GremlinClusterBuilder sslSkipCertValidation(boolean sslSkipCertValidation) {
        this.sslSkipCertValidation = sslSkipCertValidation;
        return this;
    }

    public GremlinClusterBuilder minInProcessPerConnection(int minInProcessPerConnection) {
        this.minInProcessPerConnection = minInProcessPerConnection;
        return this;
    }

    public GremlinClusterBuilder maxInProcessPerConnection(int maxInProcessPerConnection) {
        this.maxInProcessPerConnection = maxInProcessPerConnection;
        return this;
    }

    public GremlinClusterBuilder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
        this.maxSimultaneousUsagePerConnection = maxSimultaneousUsagePerConnection;
        return this;
    }

    public GremlinClusterBuilder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
        this.minSimultaneousUsagePerConnection = minSimultaneousUsagePerConnection;
        return this;
    }

    public GremlinClusterBuilder maxConnectionPoolSize(int maxSize) {
        this.maxConnectionPoolSize = maxSize;
        return this;
    }

    public GremlinClusterBuilder minConnectionPoolSize(int minSize) {
        this.minConnectionPoolSize = minSize;
        return this;
    }

    public GremlinClusterBuilder resultIterationBatchSize(int size) {
        this.resultIterationBatchSize = size;
        return this;
    }

    public GremlinClusterBuilder maxWaitForConnection(int maxWait) {
        this.maxWaitForConnection = maxWait;
        return this;
    }

    public GremlinClusterBuilder maxWaitForClose(int maxWait) {
        this.maxWaitForClose = maxWait;
        return this;
    }

    public GremlinClusterBuilder maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public GremlinClusterBuilder channelizer(String channelizerClass) {
        this.channelizer = channelizerClass;
        return this;
    }

    public GremlinClusterBuilder channelizer(Class channelizerClass) {
        return this.channelizer(channelizerClass.getCanonicalName());
    }

    public GremlinClusterBuilder validationRequest(String script) {
        this.validationRequest = script;
        return this;
    }

    public GremlinClusterBuilder reconnectInterval(int interval) {
        this.reconnectInterval = interval;
        return this;
    }

    public GremlinClusterBuilder loadBalancingStrategy(Supplier<LoadBalancingStrategy> loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
        return this;
    }

    public GremlinClusterBuilder authProperties(AuthProperties authProps) {
        this.authProps = authProps;
        return this;
    }

    public GremlinClusterBuilder credentials(String username, String password) {
        this.authProps = this.authProps.with(AuthProperties.Property.USERNAME, username).with(AuthProperties.Property.PASSWORD, password);
        return this;
    }

    public GremlinClusterBuilder protocol(String protocol) {
        this.authProps = this.authProps.with(AuthProperties.Property.PROTOCOL, protocol);
        return this;
    }

    public GremlinClusterBuilder jaasEntry(String jaasEntry) {
        this.authProps = this.authProps.with(AuthProperties.Property.JAAS_ENTRY, jaasEntry);
        return this;
    }

    public GremlinClusterBuilder addContactPoint(String address) {
        try {
            InetAddress.getByName(address);
            this.addresses.add(address);
            return this;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public GremlinClusterBuilder addContactPoints(String ... addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public GremlinClusterBuilder addContactPoints(Collection<String> addresses) {
        for (String address : addresses) {
            this.addContactPoint(address);
        }
        return this;
    }

    public GremlinClusterBuilder port(int port) {
        this.port = port;
        return this;
    }

    public GremlinClusterBuilder handshakeInterceptor(HandshakeInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    List<InetSocketAddress> getContactPoints() {
        return this.addresses.stream().map(addy -> new InetSocketAddress((String)addy, this.port)).collect(Collectors.toList());
    }

    public GremlinCluster create() {
        return new GremlinCluster(this.addresses, s -> {
            Cluster.Builder builder = Cluster.build().reconnectInterval(this.reconnectInterval).maxWaitForConnection(this.maxWaitForConnection).enableSsl(this.enableSsl).maxInProcessPerConnection(this.maxInProcessPerConnection).minSimultaneousUsagePerConnection(this.minSimultaneousUsagePerConnection).port(this.port).authProperties(this.authProps).loadBalancingStrategy(this.loadBalancingStrategy.get()).validationRequest(this.validationRequest).channelizer(this.channelizer).maxContentLength(this.maxContentLength).maxWaitForClose(this.maxWaitForClose).resultIterationBatchSize(this.resultIterationBatchSize).minConnectionPoolSize(this.minConnectionPoolSize).maxConnectionPoolSize(this.maxConnectionPoolSize).maxSimultaneousUsagePerConnection(this.maxSimultaneousUsagePerConnection).minInProcessPerConnection(this.minInProcessPerConnection).sslSkipCertValidation(this.sslSkipCertValidation).sslCipherSuites(this.sslCipherSuites).sslEnabledProtocols(this.sslEnabledProtocols).keyStoreType(this.keyStoreType).trustStorePassword(this.trustStorePassword).trustStore(this.trustStore).keyStorePassword(this.keyStorePassword).keyStore(this.keyStore).keepAliveInterval(this.keepAliveInterval).sslContext(this.sslContext).serializer(this.serializer).path(this.path).workerPoolSize(this.workerPoolSize).nioPoolSize(this.nioPoolSize).handshakeInterceptor(this.interceptor);
            if (s != null) {
                builder = builder.addContactPoint(s);
            }
            return builder.create();
        }, this.refreshOnErrorThreshold, this.refreshOnErrorEventHandler);
    }
}

