/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneInstanceProperties;

public enum EndpointsType implements EndpointsSelector
{
    All{

        @Override
        public Collection<String> getEndpoints(String clusterEndpoint, String readerEndpoint, Collection<NeptuneInstanceProperties> instances) {
            return instances.stream().filter(NeptuneInstanceProperties::isAvailable).map(NeptuneInstanceProperties::getEndpoint).collect(Collectors.toList());
        }
    }
    ,
    Primary{

        @Override
        public Collection<String> getEndpoints(String clusterEndpoint, String readerEndpoint, Collection<NeptuneInstanceProperties> instances) {
            List<String> results = instances.stream().filter(NeptuneInstanceProperties::isPrimary).filter(NeptuneInstanceProperties::isAvailable).map(NeptuneInstanceProperties::getEndpoint).collect(Collectors.toList());
            if (results.isEmpty()) {
                logger.warn("Unable to get Primary endpoint so getting ClusterEndpoint instead");
                return ClusterEndpoint.getEndpoints(clusterEndpoint, readerEndpoint, instances);
            }
            return results;
        }
    }
    ,
    ReadReplicas{

        @Override
        public Collection<String> getEndpoints(String clusterEndpoint, String readerEndpoint, Collection<NeptuneInstanceProperties> instances) {
            List<String> results = instances.stream().filter(NeptuneInstanceProperties::isReader).filter(NeptuneInstanceProperties::isAvailable).map(NeptuneInstanceProperties::getEndpoint).collect(Collectors.toList());
            if (results.isEmpty()) {
                logger.warn("Unable to get ReadReplicas endpoints so getting ReaderEndpoint instead");
                return ReaderEndpoint.getEndpoints(clusterEndpoint, readerEndpoint, instances);
            }
            return results;
        }
    }
    ,
    ClusterEndpoint{

        @Override
        public Collection<String> getEndpoints(String clusterEndpoint, String readerEndpoint, Collection<NeptuneInstanceProperties> instances) {
            return Collections.singletonList(clusterEndpoint);
        }
    }
    ,
    ReaderEndpoint{

        @Override
        public Collection<String> getEndpoints(String clusterEndpoint, String readerEndpoint, Collection<NeptuneInstanceProperties> instances) {
            return Collections.singletonList(readerEndpoint);
        }
    };

    private static final Logger logger;

    static {
        logger = LoggerFactory.getLogger(EndpointsType.class);
    }
}

