/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.TooManyRequestsException;
import com.evanlennick.retry4j.CallExecutor;
import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.EndpointsType;
import software.amazon.utils.RegionUtils;

public class GetEndpointsFromLambdaProxy
implements ClusterEndpointsFetchStrategy {
    private final EndpointsType endpointsType;
    private final String lambdaName;
    private final AWSLambda lambdaClient;
    private final RetryConfig retryConfig;

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName) {
        this(endpointsType, lambdaName, RegionUtils.getCurrentRegionName());
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region) {
        this(endpointsType, lambdaName, region, "default");
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region, String iamProfile) {
        this(endpointsType, lambdaName, region, iamProfile, null);
    }

    public GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region, AWSCredentialsProvider credentials) {
        this(endpointsType, lambdaName, region, "default", credentials);
    }

    private GetEndpointsFromLambdaProxy(EndpointsType endpointsType, String lambdaName, String region, String iamProfile, AWSCredentialsProvider credentials) {
        this.endpointsType = endpointsType;
        this.lambdaName = lambdaName;
        this.lambdaClient = this.createLambdaClient(region, iamProfile, credentials);
        this.retryConfig = new RetryConfigBuilder().retryOnSpecificExceptions(new Class[]{TooManyRequestsException.class}).withMaxNumberOfTries(10).withDelayBetweenTries(10L, ChronoUnit.MILLIS).withExponentialBackoff().build();
    }

    private AWSLambda createLambdaClient(String region, String iamProfile, AWSCredentialsProvider credentials) {
        AWSLambdaClientBuilder builder = AWSLambdaClientBuilder.standard();
        builder = credentials != null ? (AWSLambdaClientBuilder)builder.withCredentials(credentials) : (!iamProfile.equals("default") ? (AWSLambdaClientBuilder)builder.withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(iamProfile)) : (AWSLambdaClientBuilder)builder.withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance()));
        if (StringUtils.isNotEmpty((String)region)) {
            builder = (AWSLambdaClientBuilder)builder.withRegion(region);
        }
        return (AWSLambda)builder.build();
    }

    @Override
    public Map<EndpointsSelector, Collection<String>> getAddresses() {
        Callable<Map> query = () -> {
            InvokeRequest invokeRequest = new InvokeRequest().withFunctionName(this.lambdaName).withPayload(String.format("\"%s\"", this.endpointsType.name()));
            InvokeResult result = this.lambdaClient.invoke(invokeRequest);
            String payload = new String(result.getPayload().array());
            HashMap<EndpointsType, List<String>> results = new HashMap<EndpointsType, List<String>>();
            results.put(this.endpointsType, Arrays.asList(payload.split(",")));
            return results;
        };
        CallExecutor executor = new CallExecutorBuilder().config(this.retryConfig).build();
        Status status = executor.execute(query);
        return (Map)status.getResult();
    }
}

