/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.GremlinClient;
import org.apache.tinkerpop.gremlin.driver.GremlinClusterCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinCluster
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinCluster.class);
    private final List<String> defaultAddresses;
    private final Function<String, Cluster> clusterBuilder;
    private final Collection<GremlinClusterCollection> clusterCollections = new CopyOnWriteArrayList<GremlinClusterCollection>();
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private final int refreshOnErrorThreshold;
    private final Supplier<Collection<String>> refreshOnErrorEventHandler;

    public GremlinCluster(List<String> defaultAddresses, Function<String, Cluster> clusterBuilder, int refreshOnErrorThreshold, Supplier<Collection<String>> refreshOnErrorEventHandler) {
        logger.info("Created GremlinCluster, defaultAddresses: {}", defaultAddresses);
        this.defaultAddresses = defaultAddresses;
        this.clusterBuilder = clusterBuilder;
        this.refreshOnErrorThreshold = refreshOnErrorThreshold;
        this.refreshOnErrorEventHandler = refreshOnErrorEventHandler;
    }

    public GremlinClient connect(List<String> addresses, Client.Settings settings) {
        logger.info("Connecting with: {}", addresses);
        if (addresses.isEmpty()) {
            throw new IllegalStateException("You must supply at least one address");
        }
        Cluster parentCluster = this.clusterBuilder.apply(null);
        GremlinClusterCollection clusterCollection = new GremlinClusterCollection(parentCluster);
        ArrayList<GremlinClient.ClientHolder> clientHolders = new ArrayList<GremlinClient.ClientHolder>();
        for (String address : addresses) {
            Cluster cluster = this.clusterBuilder.apply(address);
            clientHolders.add(new GremlinClient.ClientHolder(address, cluster.connect()));
            clusterCollection.add(address, cluster);
        }
        this.clusterCollections.add(clusterCollection);
        return new GremlinClient(clusterCollection.getParentCluster(), settings, clientHolders, clusterCollection, this.clusterBuilder, this.refreshOnErrorThreshold, this.refreshOnErrorEventHandler);
    }

    public GremlinClient connect(List<String> addresses) {
        return this.connect(addresses, Client.Settings.build().create());
    }

    public GremlinClient connect() {
        return this.connect(this.defaultAddresses, Client.Settings.build().create());
    }

    public GremlinClient connect(Client.Settings settings) {
        return this.connect(this.defaultAddresses, settings);
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (GremlinClusterCollection clusterCollection : this.clusterCollections) {
            futures.add(clusterCollection.closeAsync());
        }
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().join();
    }
}

