/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.Map;

public class NeptuneInstanceProperties {
    private final String instanceId;
    private final String role;
    private final String endpoint;
    private final String status;
    private final String availabilityZone;
    private final String instanceType;
    private final Map<String, String> tags;

    public NeptuneInstanceProperties(String instanceId, String role, String endpoint, String status, String availabilityZone, String instanceType, Map<String, String> tags) {
        this.instanceId = instanceId;
        this.role = role;
        this.endpoint = endpoint;
        this.status = status;
        this.availabilityZone = availabilityZone;
        this.instanceType = instanceType;
        this.tags = tags;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRole() {
        return this.role;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public boolean hasTag(String tag) {
        return this.tags.containsKey(tag);
    }

    public String getTag(String tag) {
        return this.tags.get(tag);
    }

    public String getTag(String tag, String defaultValue) {
        if (!this.tags.containsKey(tag)) {
            return defaultValue;
        }
        return this.tags.get(tag);
    }

    public boolean hasTag(String tag, String value) {
        return this.hasTag(tag) && this.getTag(tag).equals(value);
    }

    public boolean isAvailable() {
        return this.getStatus().equalsIgnoreCase("Available");
    }

    public boolean isPrimary() {
        return this.getRole().equalsIgnoreCase("writer");
    }

    public boolean isReader() {
        return this.getRole().equalsIgnoreCase("reader");
    }

    public String toString() {
        return "NeptuneInstanceProperties{instanceId='" + this.instanceId + '\'' + ", endpoint='" + this.endpoint + '\'' + ", status='" + this.status + '\'' + ", availabilityZone='" + this.availabilityZone + '\'' + ", instanceType='" + this.instanceType + '\'' + ", tags=" + this.tags + '}';
    }
}

