/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import lombok.NonNull;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.msk.auth.iam.IAMLoginModule;
import software.amazon.msk.auth.iam.internals.AWSCredentialsCallback;
import software.amazon.msk.auth.iam.internals.MSKCredentialProvider;

public class IAMClientCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(IAMClientCallbackHandler.class);
    private AwsCredentialsProvider provider;

    public void configure(Map<String, ?> configs, @NonNull String saslMechanism, @NonNull List<AppConfigurationEntry> jaasConfigEntries) {
        if (saslMechanism == null) {
            throw new NullPointerException("saslMechanism is marked non-null but is null");
        }
        if (jaasConfigEntries == null) {
            throw new NullPointerException("jaasConfigEntries is marked non-null but is null");
        }
        if (!"AWS_MSK_IAM".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        Optional<AppConfigurationEntry> configEntry = jaasConfigEntries.stream().filter(j -> IAMLoginModule.class.getCanonicalName().equals(j.getLoginModuleName())).findFirst();
        this.provider = configEntry.map(c -> new MSKCredentialProvider(c.getOptions())).orElse((AwsCredentialsProvider)DefaultCredentialsProvider.create());
    }

    public void close() {
        try {
            if (this.provider instanceof AutoCloseable) {
                ((AutoCloseable)this.provider).close();
            }
        }
        catch (Exception e) {
            log.warn("Error closing provider", (Throwable)e);
        }
    }

    public void handle(@NonNull Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new NullPointerException("callbacks is marked non-null but is null");
        }
        for (Callback callback : callbacks) {
            if (log.isDebugEnabled()) {
                log.debug("Type information for callback: " + IAMClientCallbackHandler.debugClassString(callback.getClass()) + " from " + IAMClientCallbackHandler.debugClassString(this.getClass()));
            }
            if (!(callback instanceof AWSCredentialsCallback)) {
                String message = "Unsupported callback type: " + IAMClientCallbackHandler.debugClassString(callback.getClass()) + " from " + IAMClientCallbackHandler.debugClassString(this.getClass());
                log.error(message);
                throw new UnsupportedCallbackException(callback, message);
            }
            this.handleCallback((AWSCredentialsCallback)callback);
        }
    }

    protected static String debugClassString(Class<?> clazz) {
        return "class: " + clazz.getName() + " classloader: " + clazz.getClassLoader().toString();
    }

    protected void handleCallback(AWSCredentialsCallback callback) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Selecting provider {} to load credentials", (Object)this.provider.getClass().getName());
        }
        try {
            callback.setAwsCredentials(this.provider.resolveCredentials());
        }
        catch (Exception e) {
            callback.setLoadingException(e);
        }
    }
}

