/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSKCredentialProvider
implements AWSCredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(MSKCredentialProvider.class);
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";
    private final AWSCredentialsProvider delegate;

    public MSKCredentialProvider(Map<String, ?> options) {
        this(options, MSKCredentialProvider.getProfileProvider(options));
    }

    MSKCredentialProvider(Map<String, ?> options, Optional<ProfileCredentialsProvider> profileCredentialsProvider) {
        List delegateList = this.getListOfDelegates(profileCredentialsProvider);
        this.delegate = new AWSCredentialsProviderChain(delegateList);
        if (log.isDebugEnabled()) {
            log.debug("Number of options to configure credential provider {}", (Object)options.size());
        }
    }

    private List getListOfDelegates(Optional<ProfileCredentialsProvider> profileCredentialsProvider) {
        ArrayList<DefaultAWSCredentialsProviderChain> delegateList = new ArrayList<DefaultAWSCredentialsProviderChain>();
        profileCredentialsProvider.ifPresent(delegateList::add);
        delegateList.add(new DefaultAWSCredentialsProviderChain());
        return delegateList;
    }

    private static Optional<ProfileCredentialsProvider> getProfileProvider(Map<String, ?> options) {
        return Optional.ofNullable(options.get(AWS_PROFILE_NAME_KEY)).map(p -> {
            if (log.isDebugEnabled()) {
                log.debug("Profile name {}", p);
            }
            return new ProfileCredentialsProvider((String)p);
        });
    }

    public AWSCredentials getCredentials() {
        return this.delegate.getCredentials();
    }

    public void refresh() {
        this.delegate.refresh();
    }
}

