/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.tracing;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Subsegment;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;

public final class TracingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TracingUtils.class);
    private static ObjectMapper objectMapper;

    public static void putAnnotation(String key, String value) {
        if (!TracingUtils.isValidAnnotationKey(key)) {
            LOG.warn("Ignoring annotation with unsupported characters in key: {}", (Object)key);
            return;
        }
        AWSXRay.getCurrentSubsegmentOptional().ifPresent(segment -> segment.putAnnotation(key, value));
    }

    public static void putAnnotation(String key, Number value) {
        if (!TracingUtils.isValidAnnotationKey(key)) {
            LOG.warn("Ignoring annotation with unsupported characters in key: {}", (Object)key);
            return;
        }
        AWSXRay.getCurrentSubsegmentOptional().ifPresent(segment -> segment.putAnnotation(key, value));
    }

    private static boolean isValidAnnotationKey(String key) {
        return key.matches("^[a-zA-Z0-9_]+$");
    }

    public static void putAnnotation(String key, Boolean value) {
        AWSXRay.getCurrentSubsegmentOptional().ifPresent(segment -> segment.putAnnotation(key, value));
    }

    public static void putMetadata(String key, Object value) {
        String namespace = AWSXRay.getCurrentSubsegmentOptional().map(Subsegment::getNamespace).orElse(LambdaHandlerProcessor.serviceName());
        TracingUtils.putMetadata(namespace, key, value);
    }

    public static void putMetadata(String namespace, String key, Object value) {
        AWSXRay.getCurrentSubsegmentOptional().ifPresent(segment -> segment.putMetadata(namespace, key, value));
    }

    public static void withEntitySubsegment(String name, Entity entity, Consumer<Subsegment> subsegment) {
        AWSXRay.setTraceEntity((Entity)entity);
        TracingUtils.withEntitySubsegment(LambdaHandlerProcessor.serviceName(), name, entity, subsegment);
    }

    public static void withEntitySubsegment(String namespace, String name, Entity entity, Consumer<Subsegment> subsegment) {
        AWSXRay.setTraceEntity((Entity)entity);
        TracingUtils.withSubsegment(namespace, name, subsegment);
    }

    public static void withSubsegment(String name, Consumer<Subsegment> subsegment) {
        TracingUtils.withSubsegment(LambdaHandlerProcessor.serviceName(), name, subsegment);
    }

    public static void withSubsegment(String namespace, String name, Consumer<Subsegment> subsegment) {
        Subsegment segment = AWSXRay.beginSubsegment((String)("## " + name));
        segment.setNamespace(namespace);
        try {
            subsegment.accept(segment);
        }
        finally {
            AWSXRay.endSubsegment();
        }
    }

    public static void defaultObjectMapper(ObjectMapper objectMapper) {
        TracingUtils.objectMapper = objectMapper;
    }

    public static ObjectMapper objectMapper() {
        return objectMapper;
    }
}

