/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.utilities;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.jackson.JacksonRuntime;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;
import software.amazon.lambda.powertools.utilities.jmespath.Base64GZipFunction;
import software.amazon.lambda.powertools.utilities.jmespath.JsonFunction;

public class JsonConfig {
    private static final ThreadLocal<ObjectMapper> om = ThreadLocal.withInitial(() -> {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    });
    private final FunctionRegistry defaultFunctions = FunctionRegistry.defaultRegistry();
    private final FunctionRegistry customFunctions = this.defaultFunctions.extend(new Function[]{new Base64Function(), new Base64GZipFunction(), new JsonFunction()});
    private final RuntimeConfiguration configuration = new RuntimeConfiguration.Builder().withFunctionRegistry(this.customFunctions).build();
    private JmesPath<JsonNode> jmesPath = new JacksonRuntime(this.configuration, this.getObjectMapper());

    private JsonConfig() {
    }

    public static JsonConfig get() {
        return ConfigHolder.instance;
    }

    public ObjectMapper getObjectMapper() {
        return om.get();
    }

    public JmesPath<JsonNode> getJmesPath() {
        return this.jmesPath;
    }

    public <T extends BaseFunction> void addFunction(T function) {
        FunctionRegistry functionRegistryWithExtendedFunctions = this.configuration.functionRegistry().extend(new Function[]{function});
        RuntimeConfiguration updatedConfig = new RuntimeConfiguration.Builder().withFunctionRegistry(functionRegistryWithExtendedFunctions).build();
        this.jmesPath = new JacksonRuntime(updatedConfig, this.getObjectMapper());
    }

    private static class ConfigHolder {
        private static final JsonConfig instance = new JsonConfig();

        private ConfigHolder() {
        }
    }
}

