/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.cache;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataStore {
    private final Map<String, ValueNode> store = new ConcurrentHashMap<String, ValueNode>();

    public void put(String key, Object value, Instant time) {
        this.store.put(key, new ValueNode(value, time));
    }

    public void remove(String key) {
        this.store.remove(key);
    }

    public Object get(String key) {
        ValueNode node = this.store.get(key);
        return node != null ? node.value : null;
    }

    public boolean hasExpired(String key, Instant now) {
        ValueNode node = this.store.get(key);
        if (node == null) {
            return true;
        }
        boolean hasExpired = now.isAfter(node.time);
        if (hasExpired) {
            this.remove(key);
        }
        return hasExpired;
    }

    static class ValueNode {
        public final Object value;
        public final Instant time;

        public ValueNode(Object value, Instant time) {
            this.value = value;
            this.time = time;
        }
    }
}

