/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.cache;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.lambda.powertools.parameters.cache.DataStore;

public class CacheManager {
    static final Duration DEFAULT_MAX_AGE_SECS = Duration.of(5L, ChronoUnit.SECONDS);
    private final DataStore store;
    private final AtomicReference<Duration> defaultMaxAge = new AtomicReference<Duration>(DEFAULT_MAX_AGE_SECS);
    private final ThreadLocal<Duration> maxAge = ThreadLocal.withInitial(() -> null);

    public CacheManager() {
        this.store = new DataStore();
    }

    public <T> Optional<T> getIfNotExpired(String key, Instant now) {
        if (this.store.hasExpired(key, now)) {
            return Optional.empty();
        }
        return Optional.of(this.store.get(key));
    }

    public void setExpirationTime(Duration duration) {
        this.maxAge.set(duration);
    }

    public void setDefaultExpirationTime(Duration duration) {
        this.defaultMaxAge.set(duration);
    }

    public <T> void putInCache(String key, T value) {
        Duration effectiveMaxAge = this.maxAge.get() != null ? this.maxAge.get() : this.defaultMaxAge.get();
        this.store.put(key, value, Clock.systemDefaultZone().instant().plus(effectiveMaxAge));
    }

    public void resetExpirationTime() {
        this.maxAge.remove();
    }
}

